/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractReturningDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    public AbstractReturningDelegate(PostInsertIdentityPersister persister) {
        this.persister = persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object performInsert(PreparedStatementDetails insertStatementDetails, JdbcValueBindings valueBindings, Object entity, SharedSessionContractImplementor session) {
        session.getJdbcServices().getSqlStatementLogger().logStatement(insertStatementDetails.getSqlString());
        try {
            valueBindings.beforeStatement(insertStatementDetails);
            Object object = this.executeAndExtract(insertStatementDetails.getSqlString(), insertStatementDetails.getStatement(), session);
            return object;
        }
        finally {
            if (insertStatementDetails.getStatement() != null) {
                insertStatementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(insertStatementDetails.getMutatingTableDetails());
            session.getJdbcCoordinator().afterStatementExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object performInsert(String insertSql, SharedSessionContractImplementor session, Binder binder) {
        PreparedStatement insert = this.prepareStatement(insertSql, session);
        try {
            binder.bindValues(insert);
            Object object = this.executeAndExtract(insertSql, insert, session);
            this.releaseStatement(insert, session);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.releaseStatement(insert, session);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString(this.persister), insertSql);
            }
        }
    }

    protected PostInsertIdentityPersister getPersister() {
        return this.persister;
    }

    protected abstract Object executeAndExtract(String var1, PreparedStatement var2, SharedSessionContractImplementor var3);

    protected void releaseStatement(PreparedStatement insert, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(insert);
        jdbcCoordinator.afterStatementExecution();
    }
}

