/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class BooleanFilterSpec
extends FilterSpec {
    private final boolean value;

    BooleanFilterSpec(boolean value) {
        this.value = value;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        return this.value;
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        return this.value;
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return this.value;
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return !this.value;
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public boolean getValue() {
        return this.value;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public boolean equals(FilterSpec other) {
        return this == other;
    }

    public boolean equals(BooleanFilterSpec other) {
        return this == other;
    }

    @Override
    void toString(StringBuilder builder) {
        if (this.value) {
            builder.append("(&)");
        } else {
            builder.append("(|)");
        }
    }
}

