/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaAdmin;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.health.BaseHealth;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaProducer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;

public class KafkaSinkHealth
extends BaseHealth {
    private final KafkaAdmin admin;
    private final String topic;
    private final ReactiveKafkaProducer<?, ?> client;
    private final Duration adminClientTimeout;
    private Metric metric;

    public KafkaSinkHealth(KafkaConnectorOutgoingConfiguration config, Map<String, ?> kafkaConfiguration, ReactiveKafkaProducer<?, ?> client) {
        super(config.getChannel(), config.getHealthReadinessTopicVerification().orElse(config.getHealthTopicVerificationEnabled()), config.getHealthTopicVerificationStartupDisabled(), config.getHealthTopicVerificationReadinessDisabled());
        this.topic = config.getTopic().orElse(config.getChannel());
        this.adminClientTimeout = Duration.ofMillis(config.getHealthReadinessTimeout().orElse(config.getHealthTopicVerificationTimeout()));
        this.client = client;
        if (config.getHealthReadinessTopicVerification().orElse(config.getHealthTopicVerificationEnabled()).booleanValue()) {
            HashMap<String, Object> adminConfiguration = new HashMap<String, Object>(kafkaConfiguration);
            this.admin = KafkaAdminHelper.createAdminClient(adminConfiguration, config.getChannel(), true);
        } else {
            this.admin = null;
        }
    }

    protected synchronized Metric getMetric() {
        Producer<?, ?> producer;
        if (this.metric == null && (producer = this.client.unwrap()) != null) {
            this.metric = this.getMetric(producer.metrics());
        }
        return this.metric;
    }

    @Override
    public KafkaAdmin getAdmin() {
        return this.admin;
    }

    @Override
    protected void metricsBasedStartupCheck(HealthReport.HealthReportBuilder builder) {
        Metric metric = this.getMetric();
        if (metric != null) {
            builder.add(this.channel, (Double)metric.metricValue() >= 1.0);
        } else {
            builder.add(this.channel, true).build();
        }
    }

    @Override
    protected void metricsBasedReadinessCheck(HealthReport.HealthReportBuilder builder) {
        this.metricsBasedStartupCheck(builder);
    }

    @Override
    protected void clientBasedStartupCheck(HealthReport.HealthReportBuilder builder) {
        try {
            Map topics = (Map)this.admin.describeTopics(Collections.singleton(this.topic), new DescribeTopicsOptions().timeoutMs(Integer.valueOf((int)this.adminClientTimeout.toMillis())).includeAuthorizedOperations(false)).await().atMost(this.adminClientTimeout);
            if (topics.containsKey(this.topic)) {
                if (((TopicDescription)topics.get(this.topic)).partitions().stream().allMatch(info -> info.leader() != null)) {
                    builder.add(this.channel, true);
                } else {
                    builder.add(this.channel, false, "Unable to find leaders for all partitions of topic " + this.topic);
                }
            } else {
                builder.add(this.channel, false, "Unable to find topic " + this.topic);
            }
        }
        catch (Exception failed) {
            builder.add(this.channel, false, "No response from broker for topic " + this.topic + " : " + failed);
        }
    }

    @Override
    protected void clientBasedReadinessCheck(HealthReport.HealthReportBuilder builder) {
        try {
            this.admin.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf((int)this.adminClientTimeout.toMillis())).includeAuthorizedOperations(false)).await().atMost(this.adminClientTimeout);
            builder.add(this.channel, true);
        }
        catch (Exception failed) {
            builder.add(this.channel, false, "Failed to get response from broker for channel " + this.channel + " : " + failed);
        }
    }
}

