/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchedWorkProcessor;
import org.hibernate.search.backend.lucene.work.impl.IndexingWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWork;

public class LuceneBatchedWork<T>
implements BatchedWork<LuceneBatchedWorkProcessor> {
    public final IndexingWork<T> work;
    public final CompletableFuture<T> future;

    LuceneBatchedWork(IndexingWork<T> work, CompletableFuture<T> future) {
        this.work = work;
        this.future = future;
    }

    public void submitTo(LuceneBatchedWorkProcessor processor) {
        try {
            T result = processor.submit(this.work);
            this.future.complete(result);
        }
        catch (RuntimeException e) {
            this.markAsFailed(e);
        }
    }

    public void markAsFailed(Throwable t) {
        this.future.completeExceptionally(t);
    }

    String getQueuingKey() {
        return this.work.getQueuingKey();
    }
}

