/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class LuceneCommonMinimumShouldMatchConstraint {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Integer matchingClausesNumber;
    private final Integer matchingClausesPercent;

    LuceneCommonMinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
        this.matchingClausesNumber = matchingClausesNumber;
        this.matchingClausesPercent = matchingClausesPercent;
    }

    int toMinimum(int totalShouldClauseNumber) {
        int minimum = this.matchingClausesNumber != null ? (this.matchingClausesNumber >= 0 ? this.matchingClausesNumber : totalShouldClauseNumber + this.matchingClausesNumber) : (this.matchingClausesPercent >= 0 ? this.matchingClausesPercent * totalShouldClauseNumber / 100 : totalShouldClauseNumber + this.matchingClausesPercent * totalShouldClauseNumber / 100);
        if (minimum < 1 || minimum > totalShouldClauseNumber) {
            throw log.minimumShouldMatchMinimumOutOfBounds(totalShouldClauseNumber, minimum);
        }
        return minimum;
    }

    static int minimumShouldMatch(NavigableMap<Integer, LuceneCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints, Collection<?> shouldClauses) {
        return LuceneCommonMinimumShouldMatchConstraint.minimumShouldMatch(minimumShouldMatchConstraints, shouldClauses.size());
    }

    static int minimumShouldMatch(NavigableMap<Integer, LuceneCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints, int shouldClauses) {
        Map.Entry<Integer, LuceneCommonMinimumShouldMatchConstraint> entry = minimumShouldMatchConstraints.lowerEntry(shouldClauses);
        if (entry != null) {
            return entry.getValue().toMinimum(shouldClauses);
        }
        return shouldClauses;
    }
}

