/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointSpatialWithinCirclePredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneGeoPointSpatialWithinCirclePredicate(Builder builder) {
        super(builder);
    }

    private static class Builder
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<GeoPoint>
    implements SpatialWithinCirclePredicateBuilder {
        protected GeoPoint center;
        protected double radiusInMeters;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void circle(GeoPoint center, double radius, DistanceUnit unit) {
            this.center = center;
            this.radiusInMeters = unit.toMeters(radius);
        }

        public SearchPredicate build() {
            return new LuceneGeoPointSpatialWithinCirclePredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return LatLonPoint.newDistanceQuery((String)this.absoluteFieldPath, (double)this.center.latitude(), (double)this.center.longitude(), (double)this.radiusInMeters);
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<SpatialWithinCirclePredicateBuilder, GeoPoint> {
        @Override
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

