/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.EnumSet;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.msc.service.DuplicateServiceException;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentUnitOpenAPIModelConfiguration;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIHttpHandlerServiceInstaller;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIModelServiceInstaller;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;

public class OpenAPIDocumentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = context.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
            DeploymentUnitOpenAPIModelConfiguration configuration = new DeploymentUnitOpenAPIModelConfiguration(unit);
            if (configuration.isEnabled()) {
                OpenApiConfig config = configuration.getOpenApiConfig();
                if (config.modelReader() != null || config.filter() != null || configuration.getStaticFile() != null || OpenAPIDocumentProcessor.isRestful(unit)) {
                    try {
                        new OpenAPIModelServiceInstaller(configuration).install(context);
                        new OpenAPIHttpHandlerServiceInstaller(configuration).install(context);
                    }
                    catch (DuplicateServiceException e) {
                        MicroProfileOpenAPILogger.LOGGER.endpointAlreadyRegistered(configuration.getHostName(), unit.getName());
                    }
                }
            } else {
                MicroProfileOpenAPILogger.LOGGER.disabled(unit.getName());
            }
        }
    }

    private static boolean isRestful(DeploymentUnit unit) {
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (JaxrsAnnotations annotation : EnumSet.allOf(JaxrsAnnotations.class)) {
            if (index.getAnnotations(annotation.getDotName()).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

