/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.spi.OASFactoryResolverImpl;
import io.undertow.servlet.api.DeploymentInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.IndexView;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.jboss.vfs.VirtualFile;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIModelConfiguration;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class OpenAPIModelServiceInstaller
implements DeploymentServiceInstaller {
    private static final String DEFAULT_TITLE = "Generated API";
    private static final Set<String> REQUISITE_LISTENERS = Collections.singleton("http");
    private final OpenAPIModelConfiguration configuration;

    public OpenAPIModelServiceInstaller(OpenAPIModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public void install(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        final String deploymentName = unit.getName();
        final VirtualFile root = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        ArrayList indexes = new ArrayList(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
        if (unit.getParent() != null) {
            indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getParent().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
            for (DeploymentUnit subUnit : (AttachmentList)unit.getParent().getAttachment(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS)) {
                indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)subUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
            }
        }
        final CompositeIndex index = CompositeIndex.create((Collection)indexes.stream().map(IndexView.class::cast).collect(Collectors.toList()));
        final Module module = (Module)unit.getAttachment(Attachments.MODULE);
        final JBossWebMetaData metaData = ((WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        final OpenApiConfig config = this.configuration.getOpenApiConfig();
        final Map.Entry<VirtualFile, Format> entry = this.configuration.getStaticFile();
        final boolean useRelativeServerURLs = this.configuration.useRelativeServerURLs();
        String serverName = this.configuration.getServerName();
        String hostName = this.configuration.getHostName();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        final ServiceDependency deploymentInfo = ServiceDependency.on((ServiceName)UndertowService.deploymentServiceName((ServiceName)unit.getServiceName()).append(UndertowDeploymentInfoService.SERVICE_NAME));
        Supplier<OpenAPI> factory = new Supplier<OpenAPI>(){

            @Override
            public OpenAPI get() {
                FilteredIndexView indexView = new FilteredIndexView((IndexView)index, config);
                OpenApiDocument document = OpenApiDocument.newInstance();
                document.config(config);
                document.modelFromReader(OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)module.getClassLoader(), (IndexView)indexView));
                if (entry != null) {
                    VirtualFile file = (VirtualFile)entry.getKey();
                    Format format = (Format)entry.getValue();
                    try (OpenApiStaticFile staticFile = new OpenApiStaticFile(file.openStream(), format);){
                        document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile((OpenApiConfig)config, (OpenApiStaticFile)staticFile));
                    }
                    catch (IOException e) {
                        throw MicroProfileOpenAPILogger.LOGGER.failedToLoadStaticFile(e, file.getPathNameRelativeTo(root), deploymentName);
                    }
                }
                Iterable scanners = (Iterable)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Iterable<AnnotationScanner>>(){

                    @Override
                    public Iterable<AnnotationScanner> run() {
                        return ServiceLoader.load(AnnotationScanner.class, AnnotationScanner.class.getClassLoader()).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
                    }
                });
                document.modelFromAnnotations(OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (ClassLoader)module.getClassLoader(), (IndexView)indexView, (Supplier)Functions.constantSupplier((Object)scanners)));
                document.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)module.getClassLoader(), (IndexView)indexView));
                document.initialize();
                OpenAPI model = document.get();
                DescriptionGroupMetaData descriptionMetaData = metaData.getDescriptionGroup();
                String displayName = descriptionMetaData != null ? descriptionMetaData.getDisplayName() : null;
                String title = displayName != null ? displayName : deploymentName;
                String description = descriptionMetaData != null ? descriptionMetaData.getDescription() : null;
                Info info = model.getInfo();
                if (info.getTitle().equals(OpenAPIModelServiceInstaller.DEFAULT_TITLE)) {
                    info.setTitle(title);
                }
                if (info.getDescription() == null) {
                    info.setDescription(description);
                }
                List listeners = ((Host)host.get()).getServer().getListeners();
                if (model.getServers() == null) {
                    String contextPath = ((DeploymentInfo)deploymentInfo.get()).getContextPath();
                    if (useRelativeServerURLs) {
                        model.setServers(Collections.singletonList(OASFactory.createServer().url(contextPath)));
                    } else {
                        int aliases = ((Host)host.get()).getAllAliases().size();
                        int size = 0;
                        for (UndertowListener listener : listeners) {
                            size += aliases + listener.getSocketBinding().getClientMappings().size();
                        }
                        ArrayList<Server> servers = new ArrayList<Server>(size);
                        for (UndertowListener listener : listeners) {
                            Server server;
                            SocketBinding binding = listener.getSocketBinding();
                            TreeSet<String> virtualHosts = new TreeSet<String>(((Host)host.get()).getAllAliases());
                            virtualHosts.remove(((Host)host.get()).getName());
                            InetAddress address = binding.getAddress();
                            if (!address.isAnyLocalAddress()) {
                                virtualHosts.add(address.getCanonicalHostName());
                            }
                            for (String virtualHost : virtualHosts) {
                                server = OpenAPIModelServiceInstaller.createServer(listener.getProtocol(), virtualHost, binding.getPort(), contextPath);
                                if (server == null) continue;
                                servers.add(server);
                            }
                            for (ClientMapping mapping : binding.getClientMappings()) {
                                server = OpenAPIModelServiceInstaller.createServer(listener.getProtocol(), mapping.getDestinationAddress(), mapping.getDestinationPort(), contextPath);
                                if (server == null) continue;
                                servers.add(server);
                            }
                        }
                        model.setServers(servers);
                    }
                }
                if (listeners.stream().map(UndertowListener::getProtocol).noneMatch(REQUISITE_LISTENERS::contains)) {
                    MicroProfileOpenAPILogger.LOGGER.requiredListenersNotFound(((Host)host.get()).getServer().getName(), REQUISITE_LISTENERS);
                }
                return model;
            }
        };
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(ServiceNameFactory.resolveServiceName(OpenAPIModelConfiguration.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName, (String)this.configuration.getPath()))).requires(List.of(host, deploymentInfo))).build()).install(context);
    }

    private static Server createServer(String protocol, String host, int port, String path) {
        try {
            URL url = new URL(protocol, host, port, path);
            if (port == url.getDefaultPort()) {
                url = new URL(protocol, host, path);
            }
            return OASFactory.createServer().url(url.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static {
        OASFactoryResolver.setInstance((OASFactoryResolver)new OASFactoryResolverImpl());
    }
}

