/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContextInitializerProvider;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializationContextBuilder {
    private static final String PROTOSTREAM_BASE_PACKAGE_NAME = BaseMarshaller.class.getPackage().getName();
    private final DefaultSerializationContext context = new DefaultSerializationContext();

    public SerializationContextBuilder(ClassLoaderMarshaller marshaller) {
        this.register(Collections.singleton(new LangSerializationContextInitializer(marshaller)));
        this.register(EnumSet.allOf(DefaultSerializationContextInitializerProvider.class));
    }

    public ImmutableSerializationContext build() {
        return this.context.get();
    }

    public SerializationContextBuilder register(SerializationContextInitializer initializer) {
        this.init(initializer);
        return this;
    }

    public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        for (SerializationContextInitializer serializationContextInitializer : initializers) {
            this.init(serializationContextInitializer);
        }
        return this;
    }

    public SerializationContextBuilder load(ClassLoader loader) {
        this.tryLoad(loader);
        return this;
    }

    public SerializationContextBuilder require(ClassLoader loader) {
        if (!this.tryLoad(loader)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    private boolean tryLoad(final ClassLoader loader) {
        PrivilegedAction<Collection<SerializationContextInitializer>> action = new PrivilegedAction<Collection<SerializationContextInitializer>>(){

            @Override
            public Collection<SerializationContextInitializer> run() {
                return ServiceLoader.load(SerializationContextInitializer.class, loader).stream().map(Supplier::get).collect(Collectors.toList());
            }
        };
        return this.init((Collection)WildFlySecurityManager.doUnchecked((PrivilegedAction)action));
    }

    private boolean init(Collection<SerializationContextInitializer> initializers) {
        boolean init = false;
        LinkedList<SerializationContextInitializer> retries = new LinkedList<SerializationContextInitializer>();
        for (SerializationContextInitializer initializer : initializers) {
            if (initializer.getClass().getName().startsWith(PROTOSTREAM_BASE_PACKAGE_NAME)) continue;
            try {
                this.init(initializer);
                init = true;
            }
            catch (DescriptorParserException e) {
                retries.add(initializer);
            }
        }
        return retries.isEmpty() || retries.size() == initializers.size() ? init : this.init(retries) || init;
    }

    void init(SerializationContextInitializer initializer) {
        initializer.registerSchema((SerializationContext)this.context);
        initializer.registerMarshallers((SerializationContext)this.context);
    }
}

