/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.group;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.infinispan.group.LocalGroup;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class LocalGroupServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<ServerEnvironment, Group> {
    private final SupplierDependency<ServerEnvironment> environment = new ServiceSupplierDependency(ServerEnvironmentService.SERVICE_NAME);

    public LocalGroupServiceConfigurator(ServiceName name) {
        super(name);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer group = this.environment.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(group, (Function)this, this.environment);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Group apply(ServerEnvironment environment) {
        return new LocalGroup(environment.getNodeName(), "local");
    }
}

