/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.listener.KeyFilter;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryListener;
import org.wildfly.clustering.server.infinispan.ClusteringServerLogger;
import org.wildfly.clustering.server.infinispan.group.InfinispanAddressResolver;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(observation=Listener.Observation.POST)
public class CacheRegistry<K, V>
implements Registry<K, V>,
ExceptionRunnable<CacheException>,
Function<RegistryListener<K, V>, ExecutorService> {
    private final Map<RegistryListener<K, V>, ExecutorService> listeners = new ConcurrentHashMap<RegistryListener<K, V>, ExecutorService>();
    private final Cache<Address, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final Group group;
    private final Runnable closeTask;
    private final Map.Entry<K, V> entry;
    private final Invoker invoker;
    private final KeyPartitioner partitioner;
    private final Executor executor;

    public CacheRegistry(CacheRegistryConfiguration<K, V> config, Map.Entry<K, V> entry, Runnable closeTask) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.closeTask = closeTask;
        this.executor = config.getBlockingManager().asExecutor(this.getClass().getName());
        this.partitioner = (KeyPartitioner)this.cache.getAdvancedCache().getComponentRegistry().getLocalComponent(KeyPartitioner.class);
        this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(entry);
        this.invoker = new RetryingInvoker(this.cache);
        this.invoker.invoke((ExceptionRunnable)this);
        this.cache.addListener((Object)this, (CacheEventFilter)new KeyFilter(Address.class), null);
    }

    public void run() {
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)InfinispanAddressResolver.INSTANCE.apply(this.group.getLocalMember()), this.entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block14: {
            this.cache.removeListener((Object)this);
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove((Object)InfinispanAddressResolver.INSTANCE.apply(this.group.getLocalMember()));
            }
            catch (CacheException e) {
                ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                break block14;
            }
            finally {
                for (ExecutorService executor : this.listeners.values()) {
                    this.shutdown(executor);
                }
                this.listeners.clear();
                this.closeTask.run();
            }
            for (ExecutorService executor : this.listeners.values()) {
                this.shutdown(executor);
            }
            this.listeners.clear();
            this.closeTask.run();
        }
    }

    public Registration register(RegistryListener<K, V> listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(RegistryListener<K, V> listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(RegistryListener<K, V> listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        TreeSet<Address> addresses = new TreeSet<Address>();
        for (Node member : this.group.getMembership().getMembers()) {
            addresses.add(InfinispanAddressResolver.INSTANCE.apply(member));
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : this.cache.getAdvancedCache().getAll(addresses).values()) {
            if (entry == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map.Entry<K, V> getEntry(Node node) {
        Address address = InfinispanAddressResolver.INSTANCE.apply(node);
        return (Map.Entry)this.cache.get((Object)address);
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<Address, Map.Entry<K, V>> event) {
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            boolean restoreLocalEntry;
            AdvancedCache cache = event.getCache().getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS);
            EmbeddedCacheManager container = cache.getCacheManager();
            Address localAddress = container.getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            if (!leftMembers.isEmpty()) {
                ConsistentHashLocality locality = new ConsistentHashLocality(this.partitioner, hash, localAddress);
                Iterator addresses = leftMembers.iterator();
                while (addresses.hasNext()) {
                    if (locality.isLocal(addresses.next())) continue;
                    addresses.remove();
                }
            }
            boolean bl = restoreLocalEntry = !previousMembers.contains(localAddress);
            if (!leftMembers.isEmpty() || restoreLocalEntry) {
                this.executor.execute(() -> this.lambda$topologyChanged$1(leftMembers, (Cache)cache, container, restoreLocalEntry, localAddress));
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> event(CacheEntryEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && (entry = (Map.Entry)event.getValue()) != null) {
            this.executor.execute(() -> this.notifyListeners(event.getType(), entry));
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryRemoved
    public CompletionStage<Void> removed(CacheEntryRemovedEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.executor.execute(() -> this.notifyListeners(event.getType(), entry));
        }
        return CompletableFuture.completedStage(null);
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Map.Entry<RegistryListener<K, V>, ExecutorService> entry : this.listeners.entrySet()) {
            RegistryListener<K, V> listener = entry.getKey();
            ExecutorService executor = entry.getValue();
            try {
                executor.submit(() -> {
                    try {
                        switch (type) {
                            case CACHE_ENTRY_CREATED: {
                                listener.addedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_MODIFIED: {
                                listener.updatedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_REMOVED: {
                                listener.removedEntries(entries);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(type.name());
                            }
                        }
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.registryListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName(), this.cache.getName(), type, entries);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$topologyChanged$1(Set leftMembers, Cache cache, EmbeddedCacheManager container, boolean restoreLocalEntry, Address localAddress) {
        if (!leftMembers.isEmpty()) {
            HashMap removed = new HashMap();
            try {
                for (Address leftMember : leftMembers) {
                    Map.Entry old = (Map.Entry)cache.remove((Object)leftMember);
                    if (old == null) continue;
                    removed.put(old.getKey(), old.getValue());
                }
            }
            catch (CacheException e) {
                ClusteringServerLogger.ROOT_LOGGER.registryPurgeFailed(e, container.toString(), cache.getName(), leftMembers);
            }
            if (!removed.isEmpty()) {
                this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
            }
        }
        if (restoreLocalEntry) {
            try {
                if (cache.put((Object)localAddress, this.entry) == null) {
                    this.notifyListeners(Event.Type.CACHE_ENTRY_CREATED, this.entry);
                }
            }
            catch (CacheException e) {
                ClusteringServerLogger.ROOT_LOGGER.failedToRestoreLocalRegistryEntry(e, container.toString(), cache.getName());
            }
        }
    }
}

