/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.extension.io.WorkerService;
import org.wildfly.extension.io.logging.IOLogger;
import org.wildfly.io.OptionAttributeDefinition;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

class WorkerAdd
extends AbstractAddStepHandler {
    private final AtomicInteger maxThreads;

    private static int getMaxDescriptorCount() {
        try {
            ObjectName oName = new ObjectName("java.lang:type=OperatingSystem");
            MBeanServer conn = ManagementFactory.getPlatformMBeanServer();
            Object maxResult = conn.getAttribute(oName, "MaxFileDescriptorCount");
            if (maxResult != null) {
                IOLogger.ROOT_LOGGER.tracef("System has MaxFileDescriptorCount set to %d", maxResult);
                return ((Long)maxResult).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IOLogger.ROOT_LOGGER.tracef("We cannot get MaxFileDescriptorCount from system, not applying any limits", new Object[0]);
        return -1;
    }

    private static int getCpuCount() {
        return ProcessorInfo.availableProcessors();
    }

    private static int getMaxPossibleThreadCount(int maxFD) {
        return (maxFD - 600) / 3;
    }

    private static int getSuggestedTaskCount() {
        return WorkerAdd.getCpuCount() * 16;
    }

    private static int getSuggestedIoThreadCount() {
        return WorkerAdd.getCpuCount() * 2;
    }

    private static int getWorkerThreads(String workerName, int totalWorkerCount) {
        int suggestedCount;
        int count = suggestedCount = WorkerAdd.getSuggestedTaskCount();
        int maxFD = WorkerAdd.getMaxDescriptorCount();
        if (maxFD > -1) {
            int maxPossible = WorkerAdd.getMaxPossibleThreadCount(maxFD);
            if ((maxPossible /= totalWorkerCount) < 5) {
                count = 5;
            } else if (maxPossible < suggestedCount) {
                count = maxPossible;
                IOLogger.ROOT_LOGGER.lowFD(workerName, suggestedCount, WorkerAdd.getCpuCount());
            }
        }
        return count;
    }

    private static int getGlobalSuggestedCount(OperationContext context, ModelNode workers) throws OperationFailedException {
        int count = 0;
        if (!workers.isDefined()) {
            return count;
        }
        for (Property property : workers.asPropertyList()) {
            ModelNode worker = property.getValue();
            ModelNode ioThreadsModel = WorkerResourceDefinition.WORKER_IO_THREADS.resolveModelAttribute(context, worker);
            ModelNode maxTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.resolveModelAttribute(context, worker);
            count = ioThreadsModel.isDefined() ? (count += ioThreadsModel.asInt()) : (count += WorkerAdd.getSuggestedIoThreadCount());
            if (maxTaskThreadsModel.isDefined()) {
                count += maxTaskThreadsModel.asInt();
                continue;
            }
            count += WorkerAdd.getSuggestedTaskCount();
        }
        return count;
    }

    static void checkWorkerConfiguration(OperationContext context, ModelNode workers) throws OperationFailedException {
        IOLogger.ROOT_LOGGER.trace("Checking worker configuration");
        int requiredCount = WorkerAdd.getGlobalSuggestedCount(context, workers);
        IOLogger.ROOT_LOGGER.tracef("Global required thread count is: %d", requiredCount);
        int requiredFDCount = requiredCount * 3 + 600;
        IOLogger.ROOT_LOGGER.tracef("Global required FD count is: %d", requiredFDCount);
        int maxFd = WorkerAdd.getMaxDescriptorCount();
        if (maxFd > -1 && maxFd < requiredFDCount) {
            IOLogger.ROOT_LOGGER.lowGlobalFD(maxFd, requiredFDCount);
        }
    }

    WorkerAdd(AtomicInteger maxThreads) {
        this.maxThreads = maxThreads;
    }

    protected Resource createResource(OperationContext context) {
        if ("profile".equals(context.getCurrentAddress().getElement(0).getKey())) {
            return super.createResource(context);
        }
        WorkerResourceDefinition.WorkerResource r = new WorkerResourceDefinition.WorkerResource(context);
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)r);
        return r;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Resource resource = context.readResourceFromRoot(address.subAddress(0, address.size() - 1));
        ModelNode workers = Resource.Tools.readModel((Resource)resource).get(WorkerResourceDefinition.PATH.getKey());
        int allWorkerCount = workers.asList().size();
        String name = context.getCurrentAddressValue();
        XnioWorker.Builder builder = Xnio.getInstance().createWorkerBuilder();
        ModelNode val = WorkerResourceDefinition.STACK_SIZE.resolveModelAttribute(context, model);
        if (0L < val.asLong() && val.asLong() < 100000L) {
            IOLogger.ROOT_LOGGER.wrongStackSize(val.asLong(), name);
        }
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        for (OptionAttributeDefinition attr : WorkerResourceDefinition.ATTRIBUTES) {
            Option option = attr.getOption();
            ModelNode value = attr.resolveModelAttribute(context, model);
            if (!value.isDefined()) continue;
            if (attr.getType() == ModelType.INT) {
                optionMapBuilder.set(option, value.asInt());
                continue;
            }
            if (attr.getType() == ModelType.LONG) {
                optionMapBuilder.set(option, value.asLong());
                continue;
            }
            if (attr.getType() != ModelType.BOOLEAN) continue;
            optionMapBuilder.set(option, value.asBoolean());
        }
        builder.populateFromOptions(optionMapBuilder.getMap());
        builder.setWorkerName(name);
        ModelNode ioThreadsModel = WorkerResourceDefinition.WORKER_IO_THREADS.resolveModelAttribute(context, model);
        ModelNode coreTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_CORE_THREADS.resolveModelAttribute(context, model);
        ModelNode maxTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.resolveModelAttribute(context, model);
        int cpuCount = WorkerAdd.getCpuCount();
        int ioThreadsCalculated = WorkerAdd.getSuggestedIoThreadCount();
        int workerThreads = builder.getMaxWorkerPoolSize();
        int coreWorkerThreads = coreTaskThreadsModel.asInt();
        if (!ioThreadsModel.isDefined() && !maxTaskThreadsModel.isDefined()) {
            workerThreads = WorkerAdd.getWorkerThreads(name, allWorkerCount);
            builder.setWorkerIoThreads(ioThreadsCalculated);
            builder.setCoreWorkerPoolSize(coreWorkerThreads);
            builder.setMaxWorkerPoolSize(workerThreads);
            IOLogger.ROOT_LOGGER.printDefaults(name, ioThreadsCalculated, workerThreads, cpuCount);
        } else {
            if (!ioThreadsModel.isDefined()) {
                builder.setWorkerIoThreads(ioThreadsCalculated);
                IOLogger.ROOT_LOGGER.printDefaultsIoThreads(name, ioThreadsCalculated, cpuCount);
            }
            if (!maxTaskThreadsModel.isDefined()) {
                workerThreads = WorkerAdd.getWorkerThreads(name, allWorkerCount);
                builder.setCoreWorkerPoolSize(coreWorkerThreads);
                builder.setMaxWorkerPoolSize(workerThreads);
                IOLogger.ROOT_LOGGER.printDefaultsWorkerThreads(name, workerThreads, cpuCount);
            }
        }
        int workerMaxThreads = workerThreads;
        Consumer<XnioWorker> maxThreadsRecorder = worker -> this.maxThreads.addAndGet(worker != null ? workerMaxThreads : 0 - workerMaxThreads);
        CapabilityServiceBuilder capBuilder = context.getCapabilityServiceTarget().addCapability(WorkerResourceDefinition.CAPABILITY);
        Consumer workerConsumer = capBuilder.provides(WorkerResourceDefinition.CAPABILITY);
        Supplier executorSupplier = capBuilder.requires(Capabilities.MANAGEMENT_EXECUTOR);
        capBuilder.setInstance((Service)new WorkerService(workerConsumer.andThen(maxThreadsRecorder), executorSupplier, builder));
        capBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        capBuilder.install();
    }
}

