/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.jvm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class JvmType {
    private static final String BIN_DIR = "bin";
    private static final String JAVA_HOME_SYS_PROP = "java.home";
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private static final String OS_NAME_SYS_PROP = "os.name";
    private static final Collection<String> DEFAULT_MODULAR_JVM_ARGUMENTS;
    private static final Collection<String> DEFAULT_OPTIONAL_MODULAR_JVM_ARGUMENTS;
    private static final String JAVA_EXECUTABLE;
    private static final String JAVA_UNIX_EXECUTABLE = "java";
    private static final String JAVA_WIN_EXECUTABLE = "java.exe";
    private final boolean forLaunch;
    private final boolean isModularJvm;
    private final String javaExecutable;

    private JvmType(boolean forLaunch, boolean isModularJvm, String javaExecutable) {
        this.forLaunch = forLaunch;
        this.isModularJvm = isModularJvm;
        this.javaExecutable = javaExecutable;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public boolean isForLaunch() {
        return this.forLaunch;
    }

    public boolean isModularJvm() {
        return this.isModularJvm;
    }

    public Collection<String> getDefaultArguments() {
        return this.isModularJvm ? DEFAULT_MODULAR_JVM_ARGUMENTS : Collections.EMPTY_LIST;
    }

    public Collection<String> getOptionalDefaultArguments() {
        if (this.isModularJvm) {
            ArrayList<String> retVal = null;
            for (String optionalModularArgument : DEFAULT_OPTIONAL_MODULAR_JVM_ARGUMENTS) {
                if (!JvmType.packageAvailableOnJvm(this.javaExecutable, true, optionalModularArgument)) continue;
                if (retVal == null) {
                    retVal = new ArrayList<String>();
                }
                retVal.add(optionalModularArgument);
            }
            if (retVal != null) {
                return retVal;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static JvmType createFromJavaHome(String javaHome, boolean forLaunch) {
        if (javaHome == null || javaHome.trim().equals("")) {
            throw HostControllerLogger.ROOT_LOGGER.invalidJavaHome(javaHome);
        }
        File javaHomeDir = new File(javaHome);
        if (forLaunch && !javaHomeDir.exists()) {
            throw HostControllerLogger.ROOT_LOGGER.invalidJavaHome(javaHomeDir.getAbsolutePath());
        }
        File javaBinDir = new File(javaHomeDir, BIN_DIR);
        if (forLaunch && !javaBinDir.exists()) {
            throw HostControllerLogger.ROOT_LOGGER.invalidJavaHomeBin(javaBinDir.getAbsolutePath(), javaHomeDir.getAbsolutePath());
        }
        File javaExecutable = new File(javaBinDir, JAVA_EXECUTABLE);
        if (forLaunch && !javaExecutable.exists()) {
            throw HostControllerLogger.ROOT_LOGGER.cannotFindJavaExe(javaBinDir.getAbsolutePath());
        }
        return new JvmType(forLaunch, JvmType.isModularJvm(javaExecutable.getAbsolutePath(), forLaunch), javaExecutable.getAbsolutePath());
    }

    private static boolean isModularJvm(String javaExecutable, boolean forLaunch) {
        if (forLaunch) {
            try {
                return 0 == new ProcessBuilder(javaExecutable, "--add-modules=java.se", "-version").start().waitFor();
            }
            catch (Throwable t) {
                throw HostControllerLogger.ROOT_LOGGER.cannotFindJavaExe(javaExecutable);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean packageAvailableOnJvm(String javaExecutable, boolean forLaunch, String optionalModularArgument) {
        boolean result;
        if (!forLaunch) {
            return false;
        }
        ProcessBuilder builder = new ProcessBuilder(javaExecutable, optionalModularArgument, "-version");
        Process process = null;
        Path stdout = null;
        try {
            stdout = Files.createTempFile("stdout", ".txt", new FileAttribute[0]);
            process = builder.redirectErrorStream(true).redirectOutput(stdout.toFile()).start();
            result = process.waitFor(30L, TimeUnit.SECONDS) ? process.exitValue() == 0 : false;
        }
        catch (IOException | InterruptedException e) {
            result = false;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
            if (stdout != null) {
                try {
                    if (JvmType.containsWarning(stdout)) {
                        result = false;
                    }
                    Files.deleteIfExists(stdout);
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static boolean containsWarning(Path logFile) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(logFile.toFile())));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("WARNING:")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static JvmType createFromJavaExecutable(String javaExecutable, boolean forLaunch) {
        assert (javaExecutable != null);
        if (javaExecutable.equals(JAVA_WIN_EXECUTABLE) || javaExecutable.equals(JAVA_UNIX_EXECUTABLE)) {
            return JvmType.createFromEnvironmentVariable(forLaunch);
        }
        return new JvmType(forLaunch, JvmType.isModularJvm(javaExecutable, forLaunch), javaExecutable);
    }

    public static JvmType createFromSystemProperty(boolean forLaunch) {
        String javaHome = WildFlySecurityManager.getPropertyPrivileged((String)JAVA_HOME_SYS_PROP, null);
        return JvmType.createFromJavaHome(javaHome, forLaunch);
    }

    private static JvmType createFromEnvironmentVariable(boolean forLaunch) {
        String envJavaHome = WildFlySecurityManager.getEnvPropertyPrivileged((String)JAVA_HOME_ENV_VAR, null);
        if (envJavaHome != null && !"".equals(envJavaHome.trim())) {
            return JvmType.createFromJavaHome(envJavaHome, forLaunch);
        }
        return JvmType.createFromSystemProperty(forLaunch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmType jvmType = (JvmType)o;
        if (this.forLaunch != jvmType.forLaunch) {
            return false;
        }
        if (this.isModularJvm != jvmType.isModularJvm) {
            return false;
        }
        return this.javaExecutable.equals(jvmType.javaExecutable);
    }

    public int hashCode() {
        int result = this.forLaunch ? 1 : 0;
        result = 31 * result + (this.isModularJvm ? 1 : 0);
        result = 31 * result + this.javaExecutable.hashCode();
        return result;
    }

    static {
        String osSysProp = WildFlySecurityManager.getPropertyPrivileged((String)OS_NAME_SYS_PROP, (String)"UNKNOWN");
        String os = osSysProp.toLowerCase(Locale.ROOT);
        JAVA_EXECUTABLE = os.contains("win") ? JAVA_WIN_EXECUTABLE : JAVA_UNIX_EXECUTABLE;
        ArrayList<String> modularJavaOpts = new ArrayList<String>();
        modularJavaOpts.add("--add-exports=java.desktop/sun.awt=ALL-UNNAMED");
        modularJavaOpts.add("--add-exports=java.naming/com.sun.jndi.ldap=ALL-UNNAMED");
        modularJavaOpts.add("--add-exports=java.naming/com.sun.jndi.url.ldap=ALL-UNNAMED");
        modularJavaOpts.add("--add-exports=java.naming/com.sun.jndi.url.ldaps=ALL-UNNAMED");
        modularJavaOpts.add("--add-exports=jdk.naming.dns/com.sun.jndi.dns=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.lang.invoke=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.lang.reflect=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.io=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.net=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.security=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.util=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.util.concurrent=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.management/javax.management=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.naming/javax.naming=ALL-UNNAMED");
        DEFAULT_MODULAR_JVM_ARGUMENTS = Collections.unmodifiableList(modularJavaOpts);
        ArrayList<String> modularOptionalJavaOpts = new ArrayList<String>();
        modularOptionalJavaOpts.add("--add-opens=java.base/com.sun.net.ssl.internal.ssl=ALL-UNNAMED");
        DEFAULT_OPTIONAL_MODULAR_JVM_ARGUMENTS = Collections.unmodifiableList(modularOptionalJavaOpts);
    }
}

