/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.outbound;

import com.arjuna.ats.jta.utils.JTAHelper;
import jakarta.transaction.Synchronization;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;
import org.jboss.jbossts.xts.bridge.at.BridgeWrapper;

public class BridgeSynchronization
implements Synchronization {
    private final BridgeWrapper bridgeWrapper;

    public BridgeSynchronization(BridgeWrapper bridgeWrapper) {
        txbridgeLogger.logger.trace((Object)("BridgeSynchronization.<ctor>(BridgeWrapper=" + String.valueOf(bridgeWrapper) + ")"));
        this.bridgeWrapper = bridgeWrapper;
    }

    public void beforeCompletion() {
        txbridgeLogger.logger.trace((Object)"BridgeSynchronization.beforeCompletion()");
        if (!this.bridgeWrapper.prepareVolatile()) {
            txbridgeLogger.i18NLogger.error_bridge_wrapper_prepare_volatile(this.bridgeWrapper);
            throw new RuntimeException("BridgeWrapper.prepareVolatile() returned false");
        }
    }

    public void afterCompletion(int status) {
        txbridgeLogger.logger.trace((Object)("BridgeSynchronization.afterCompletion(status=" + status + "/" + JTAHelper.stringForm((int)status) + ")"));
        switch (status) {
            case 3: {
                this.bridgeWrapper.commitVolatile();
                break;
            }
            case 4: {
                this.bridgeWrapper.rollbackVolatile();
                break;
            }
            default: {
                txbridgeLogger.i18NLogger.warn_obs_unexpectedstatus(Integer.toString(status));
                this.bridgeWrapper.rollbackVolatile();
            }
        }
    }
}

