/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ProtocolSocketBinding;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.common.net.Inet;

public class EJBRemotingConnectorClientMappingsServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<List<ClientMapping>> {
    private static final ServiceName BASE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "remote", "client-mappings"});
    private volatile SupplierDependency<ProtocolSocketBinding> remotingConnectorInfo;
    private final String connectorName;

    public EJBRemotingConnectorClientMappingsServiceConfigurator(String connectorName) {
        super(BASE_NAME.append(new String[]{connectorName}));
        this.connectorName = connectorName;
    }

    public ServiceConfigurator configure(OperationContext context) {
        this.remotingConnectorInfo = new ServiceSupplierDependency(context.getCapabilityServiceName("org.wildfly.remoting.connector", this.connectorName, ProtocolSocketBinding.class));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer entry = new CompositeDependency(new Dependency[]{this.remotingConnectorInfo}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(entry, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public List<ClientMapping> get() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        ProtocolSocketBinding info = (ProtocolSocketBinding)this.remotingConnectorInfo.get();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            InetAddress destination = info.getSocketBinding().getAddress();
            String destinationName = Inet.toURLString((InetAddress)destination, (boolean)true);
            try {
                clientNetworkAddress = destination instanceof Inet4Address ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationName, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }
}

