/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Map;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.container.SynchronizationTypeAccess;
import org.jboss.as.jpa.container.UnsynchronizedEntityManagerWrapper;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionScopedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 455498112L;
    private final String puScopedName;
    private final Map properties;
    private transient EntityManagerFactory emf;
    private final SynchronizationType synchronizationType;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private transient TransactionManager transactionManager;
    private transient Boolean deferDetach;
    private transient Boolean skipQueryDetach;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf, SynchronizationType synchronizationType, TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager) {
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
        this.synchronizationType = synchronizationType;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.transactionManager = transactionManager;
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager entityManager;
        boolean isInTx = TransactionUtil.isInTx(this.transactionManager);
        if (isInTx) {
            entityManager = this.getOrCreateTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties, this.synchronizationType);
        } else {
            entityManager = NonTxEmCloser.get(this.puScopedName);
            if (entityManager == null) {
                entityManager = this.createEntityManager(this.emf, this.properties, this.synchronizationType);
                NonTxEmCloser.add(this.puScopedName, entityManager);
            }
        }
        return entityManager;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return false;
    }

    @Override
    protected boolean isInTx() {
        return TransactionUtil.isInTx(this.transactionManager);
    }

    @Override
    public void close() {
        throw JpaLogger.ROOT_LOGGER.cannotCloseTransactionContainerEntityManger();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ServiceController controller = TransactionScopedEntityManager.currentServiceContainer().getService(JPAServiceNames.getPUServiceName(this.puScopedName));
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)controller.getService();
        this.transactionManager = ContextTransactionManager.getInstance();
        this.transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)TransactionScopedEntityManager.currentServiceContainer().getService(JPAServiceNames.TRANSACTION_SYNCHRONIZATION_REGISTRY_SERVICE).getValue();
        this.emf = persistenceUnitService.getEntityManagerFactory();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    @Override
    public SynchronizationType getSynchronizationType() {
        return this.synchronizationType;
    }

    private EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String scopedPuName, Map properties, SynchronizationType synchronizationType) {
        EntityManager entityManager = TransactionUtil.getTransactionScopedEntityManager(this.puScopedName, this.transactionSynchronizationRegistry);
        if (entityManager == null) {
            entityManager = this.createEntityManager(emf, properties, synchronizationType);
            if (JpaLogger.ROOT_LOGGER.isDebugEnabled()) {
                JpaLogger.ROOT_LOGGER.debugf("%s: created entity manager session %s", TransactionUtil.getEntityManagerDetails(entityManager, scopedPuName), TransactionUtil.getTransaction(this.transactionManager).toString());
            }
            TransactionUtil.registerSynchronization(entityManager, scopedPuName, this.transactionSynchronizationRegistry, this.transactionManager);
            TransactionUtil.putEntityManagerInTransactionRegistry(scopedPuName, entityManager, this.transactionSynchronizationRegistry);
        } else {
            TransactionScopedEntityManager.testForMixedSynchronizationTypes(emf, entityManager, this.puScopedName, synchronizationType, properties);
            if (JpaLogger.ROOT_LOGGER.isDebugEnabled()) {
                JpaLogger.ROOT_LOGGER.debugf("%s: reuse entity manager session already in tx %s", TransactionUtil.getEntityManagerDetails(entityManager, scopedPuName), TransactionUtil.getTransaction(this.transactionManager).toString());
            }
        }
        return entityManager;
    }

    private EntityManager createEntityManager(EntityManagerFactory emf, Map properties, SynchronizationType synchronizationType) {
        if (SynchronizationType.UNSYNCHRONIZED.equals((Object)synchronizationType)) {
            return this.unsynchronizedEntityManagerWrapper(emf.createEntityManager(synchronizationType, properties));
        }
        if (properties != null && properties.size() > 0) {
            return emf.createEntityManager(properties);
        }
        return emf.createEntityManager();
    }

    private EntityManager unsynchronizedEntityManagerWrapper(EntityManager entityManager) {
        return new UnsynchronizedEntityManagerWrapper(entityManager);
    }

    @Override
    protected boolean deferEntityDetachUntilClose() {
        if (this.deferDetach == null) {
            this.deferDetach = true == Configuration.deferEntityDetachUntilClose(this.emf.getProperties()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.deferDetach;
    }

    @Override
    protected boolean skipQueryDetach() {
        if (this.skipQueryDetach == null) {
            this.skipQueryDetach = true == Configuration.skipQueryDetach(this.emf.getProperties()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.skipQueryDetach;
    }

    private static void testForMixedSynchronizationTypes(EntityManagerFactory emf, EntityManager entityManagerFromJTA, String scopedPuName, SynchronizationType targetSynchronizationType, Map targetProperties) {
        boolean skipMixedSyncTypeChecking = Configuration.skipMixedSynchronizationTypeCheck(emf, targetProperties);
        boolean allowJoinedUnsyncPersistenceContext = Configuration.allowJoinedUnsyncPersistenceContext(emf, targetProperties);
        if (!skipMixedSyncTypeChecking && SynchronizationType.SYNCHRONIZED.equals((Object)targetSynchronizationType) && entityManagerFromJTA instanceof SynchronizationTypeAccess && SynchronizationType.UNSYNCHRONIZED.equals((Object)((SynchronizationTypeAccess)entityManagerFromJTA).getSynchronizationType()) && (!allowJoinedUnsyncPersistenceContext || !entityManagerFromJTA.isJoinedToTransaction())) {
            throw JpaLogger.ROOT_LOGGER.badSynchronizationTypeCombination(scopedPuName);
        }
    }
}

