/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.client.exception.WebApplicationExceptionWrapper;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class DefaultResponseExceptionMapper
implements ResponseExceptionMapper {
    public Throwable toThrowable(Response response) {
        try {
            response.bufferEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WebApplicationExceptionWrapper.wrap((WebApplicationException)new WebApplicationException("Unknown error, status code " + response.getStatus(), response));
    }

    public boolean handles(int status, MultivaluedMap headers) {
        Config config = ConfigProvider.getConfig();
        boolean originalBehavior = config.getOptionalValue("resteasy.original.webapplicationexception.behavior", Boolean.TYPE).orElse(false);
        boolean serverSide = ResteasyDeployment.onServer();
        return status >= (originalBehavior || !serverSide ? 400 : 300);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

