/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;

public class ProxyInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ProxyInvocationHandler.class);
    public static final Type[] NO_TYPES = new Type[0];
    private final Object target;
    private final Set<Object> providerInstances;
    private final ResteasyClient client;
    private final AtomicBoolean closed;

    public ProxyInvocationHandler(Class<?> restClientInterface, Object target, Set<Object> providerInstances, ResteasyClient client) {
        this.target = target;
        this.providerInstances = providerInstances;
        this.client = client;
        this.closed = new AtomicBoolean();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] argsReplacement;
        boolean replacementNeeded;
        block29: {
            if (RestClientProxy.class.equals(method.getDeclaringClass())) {
                return this.invokeRestClientProxyMethod(method);
            }
            if (method.getName().equals("close") && (args == null || args.length == 0)) {
                this.close();
                return null;
            }
            if (this.closed.get() || this.client.isClosed()) {
                this.closed.set(true);
                throw new IllegalStateException("RestClientProxy is closed");
            }
            replacementNeeded = false;
            argsReplacement = args != null ? new Object[args.length] : null;
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            if (args == null) break block29;
            for (Object p : this.providerInstances) {
                if (!(p instanceof ParamConverterProvider)) continue;
                int index = 0;
                for (Object arg : args) {
                    block31: {
                        block30: {
                            Type[] genericTypes;
                            if (arg == null) continue;
                            if (parameterAnnotations[index].length <= 0) break block30;
                            ParamConverter converter = ((ParamConverterProvider)p).getConverter(arg.getClass(), null, parameterAnnotations[index]);
                            if (converter == null || (genericTypes = this.getGenericTypes(converter.getClass())).length != 1) break block31;
                            switch (genericTypes[0].getTypeName()) {
                                case "java.lang.String": {
                                    ParamConverter stringConverter = converter;
                                    argsReplacement[index] = stringConverter.toString((Object)((String)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                                case "java.lang.Integer": {
                                    ParamConverter intConverter = converter;
                                    argsReplacement[index] = intConverter.toString((Object)((Integer)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                                case "java.lang.Boolean": {
                                    ParamConverter boolConverter = converter;
                                    argsReplacement[index] = boolConverter.toString((Object)((Boolean)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                            }
                            continue;
                        }
                        argsReplacement[index] = arg;
                    }
                    ++index;
                }
            }
        }
        if (replacementNeeded) {
            args = argsReplacement;
        }
        try {
            Object result = method.invoke(this.target, args);
            Class<?> returnType = method.getReturnType();
            if (returnType.isInterface()) {
                Annotation[] annotations = method.getDeclaredAnnotations();
                boolean hasPath = false;
                boolean hasHttpMethod = false;
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> type = annotation.annotationType();
                    if (type.equals(Path.class)) {
                        hasPath = true;
                        continue;
                    }
                    if (type.getDeclaredAnnotation(HttpMethod.class) == null) continue;
                    hasHttpMethod = true;
                }
                if (!hasHttpMethod && hasPath) {
                    return ProxyInvocationHandler.createProxy(returnType, result, false, this.providerInstances, this.client, ProxyInvocationHandler.getBeanManager());
                }
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)((Object)cause)).mapException(method);
                return null;
            }
            if (cause instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)cause;
                if ((cause = rpe.getCause()) instanceof RuntimeException) {
                    throw cause;
                }
            } else {
                if (cause instanceof ProcessingException && cause.getCause() instanceof ClientHeaderFillingException) {
                    throw cause.getCause().getCause();
                }
                if (cause instanceof RuntimeException) {
                    throw cause;
                }
            }
            throw e;
        }
    }

    static Object createProxy(Class<?> resourceInterface, Object target, Set<Object> providers, ResteasyClient client, BeanManager beanManager) {
        return ProxyInvocationHandler.createProxy(resourceInterface, target, true, providers, client, beanManager);
    }

    static Object createProxy(Class<?> resourceInterface, Object target, boolean addExtendedInterfaces, Set<Object> providers, ResteasyClient client, BeanManager beanManager) {
        Class[] interfaces;
        if (addExtendedInterfaces) {
            interfaces = new Class[3];
            interfaces[1] = RestClientProxy.class;
            interfaces[2] = Closeable.class;
        } else {
            interfaces = new Class[]{resourceInterface};
        }
        Object proxy = Proxy.newProxyInstance(ProxyInvocationHandler.getClassLoader(resourceInterface), interfaces, (InvocationHandler)new ProxyInvocationHandler(resourceInterface, target, Set.copyOf(providers), client));
        ClientHeaderProviders.registerForClass(resourceInterface, proxy, beanManager);
        return proxy;
    }

    private Object invokeRestClientProxyMethod(Method method) {
        switch (method.getName()) {
            case "getClient": {
                return this.client;
            }
            case "close": {
                this.close();
                return null;
            }
        }
        throw new IllegalStateException("Unsupported RestClientProxy method: " + method);
    }

    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.close();
        }
    }

    private Type[] getGenericTypes(Class<?> aClass) {
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        Type[] genericTypes = NO_TYPES;
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
        }
        return genericTypes;
    }

    private static ClassLoader getClassLoader(Class<?> type) {
        if (System.getSecurityManager() == null) {
            return type.getClassLoader();
        }
        return AccessController.doPrivileged(type::getClassLoader);
    }

    private static BeanManager getBeanManager() {
        try {
            CDI current = CDI.current();
            return current != null ? current.getBeanManager() : null;
        }
        catch (IllegalStateException e) {
            LOGGER.debug((Object)"CDI container is not available", (Throwable)e);
            return null;
        }
    }
}

