/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceInstallerFactory;
import org.wildfly.subsystem.service.ServiceInstaller;

public class BinaryServiceInstallerProvider<T>
implements BiFunction<CapabilityServiceSupport, BinaryServiceConfiguration, Iterable<ServiceInstaller>> {
    private final BinaryServiceInstallerFactory<T> installerFactory;
    private final Function<BinaryServiceConfiguration, JndiName> jndiNameFactory;

    protected BinaryServiceInstallerProvider(BinaryServiceInstallerFactory<T> installerFactory) {
        this(installerFactory, null);
    }

    protected BinaryServiceInstallerProvider(BinaryServiceInstallerFactory<T> installerFactory, Function<BinaryServiceConfiguration, JndiName> jndiNameFactory) {
        this.installerFactory = installerFactory;
        this.jndiNameFactory = jndiNameFactory;
    }

    @Override
    public Iterable<ServiceInstaller> apply(CapabilityServiceSupport support, BinaryServiceConfiguration configuration) {
        ServiceInstaller installer = (ServiceInstaller)this.installerFactory.apply((Object)support, (Object)configuration);
        if (this.jndiNameFactory == null) {
            return List.of(installer);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(configuration).getAbsoluteName());
        ServiceName name = configuration.resolveServiceName(this.installerFactory.getServiceDescriptor());
        return List.of(installer, new BinderServiceInstaller(binding, name));
    }
}

