/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.FD_SOCK2;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class FailureDetectionProtocolResourceDefinition
extends SocketProtocolResourceDefinition<FD_SOCK2> {
    FailureDetectionProtocolResourceDefinition(String name, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(name, configurator, parentServiceConfigurator);
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<FD_SOCK2>, ProtocolConfiguration<FD_SOCK2>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String bindingName = SocketProtocolResourceDefinition.Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String clientBindingName = SocketProtocolResourceDefinition.Attribute.CLIENT_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final ServiceDependency binding = bindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)bindingName) : ServiceDependency.of(null);
        final ServiceDependency clientBinding = clientBindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)clientBindingName) : ServiceDependency.of(null);
        final ServiceDependency transport = ServiceDependency.on((UnaryServiceDescriptor)TransportConfiguration.SERVICE_DESCRIPTOR, (String)context.getCurrentAddress().getParent().getLastElement().getValue());
        return Map.entry(new UnaryOperator<ProtocolConfiguration<FD_SOCK2>>(){

            @Override
            public ProtocolConfiguration<FD_SOCK2> apply(ProtocolConfiguration<FD_SOCK2> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<FD_SOCK2>(configuration){

                    @Override
                    public FD_SOCK2 createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        SocketBinding clientSocketBinding;
                        FD_SOCK2 protocol = (FD_SOCK2)super.createProtocol(stackConfiguration);
                        SocketBinding protocolBinding = (SocketBinding)binding.get();
                        SocketBinding transportBinding = ((TransportConfiguration)transport.get()).getSocketBinding();
                        InetSocketAddress protocolBindAddress = protocolBinding != null ? protocolBinding.getSocketAddress() : null;
                        InetSocketAddress transportBindAddress = transportBinding.getSocketAddress();
                        protocol.setBindAddress((protocolBindAddress != null ? protocolBindAddress : transportBindAddress).getAddress());
                        if (protocolBinding != null) {
                            protocol.setOffset(protocolBindAddress.getPort() - transportBindAddress.getPort());
                            List clientMappings = protocolBinding.getClientMappings();
                            if (!clientMappings.isEmpty()) {
                                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                                try {
                                    protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                                    protocol.setExternalPort(mapping.getDestinationPort());
                                }
                                catch (UnknownHostException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            }
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            protocol.setClientBindPort(((SocketBinding)clientBinding.get()).getSocketAddress().getPort());
                        }
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        SocketBinding socketBinding = (SocketBinding)binding.get();
                        return socketBinding != null ? Map.of("jgroups.nio.server.fd_sock", socketBinding) : Map.of();
                    }
                };
            }
        }, binding.andThen((Consumer)clientBinding).andThen((Consumer)transport));
    }
}

