/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationFunction;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class BackupOperationExecutor
implements OperationExecutor<Map.Entry<String, XSiteAdminOperations>> {
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    public BackupOperationExecutor(FunctionExecutorRegistry<Cache<?, ?>> executors) {
        this.executors = executors;
    }

    public ModelNode execute(final OperationContext context, ModelNode operation, Operation<Map.Entry<String, XSiteAdminOperations>> executable) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress().getParent().getParent();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        Function mapper = new Function<Cache<?, ?>, Map.Entry<String, XSiteAdminOperations>>(){

            @Override
            public Map.Entry<String, XSiteAdminOperations> apply(Cache<?, ?> cache) {
                String site = context.getCurrentAddressValue();
                return new AbstractMap.SimpleImmutableEntry<String, XSiteAdminOperations>(site, (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getLocalComponent(XSiteAdminOperations.class));
            }
        };
        FunctionExecutor executor = this.executors.getExecutor((Object)ServiceDependency.on((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE, (String)containerName, (String)cacheName));
        return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new OperationFunction((ExpressionResolver)context, operation, mapper, executable)) : null;
    }
}

