/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.subsystem.service.ServiceDependency;

public class CustomStoreResourceDefinition<C extends StoreConfiguration, B extends StoreConfigurationBuilder<C, B>>
extends StoreResourceDefinition<C, B> {
    static final PathElement PATH = CustomStoreResourceDefinition.pathElement("custom");

    CustomStoreResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(PATH, WILDCARD_PATH), (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class), StoreConfigurationBuilder.class);
    }

    @Override
    public Map.Entry<Map.Entry<Supplier<B>, Consumer<B>>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        Object entry = super.resolve(context, model);
        Consumer configurator = (Consumer)((Map.Entry)entry.getKey()).getValue();
        Stream dependencies = (Stream)entry.getValue();
        PathAddress cacheAddress = context.getCurrentAddress().getParent();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        final String className = Attribute.CLASS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final ServiceDependency cacheModules = ServiceDependency.on(CacheResourceDefinition.CACHE_MODULES, (String)containerName, (String)cacheName);
        Supplier builderFactory = new Supplier<B>(){

            @Override
            public B get() {
                List modules = (List)cacheModules.get();
                AggregatedClassLoader loader = modules.size() > 1 ? new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toList())) : ((Module)modules.get(0)).getClassLoader();
                try {
                    Class<StoreConfigurationBuilder> storeClass = loader.loadClass(className).asSubclass(StoreConfigurationBuilder.class);
                    return new ConfigurationBuilder().persistence().addStore(storeClass);
                }
                catch (ClassCastException | ClassNotFoundException e) {
                    throw InfinispanLogger.ROOT_LOGGER.invalidCacheStore(e, className);
                }
            }
        };
        return MapEntry.of((Object)MapEntry.of((Object)builderFactory, (Object)configurator), Stream.concat(dependencies, Stream.of(cacheModules)));
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CLASS("class", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

