/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class SharedStateCacheResourceDefinition
extends ClusteredCacheResourceDefinition {
    static final Set<PathElement> REQUIRED_CHILDREN = Set.of(PartitionHandlingResourceDefinition.PATH, StateTransferResourceDefinition.PATH, BackupsResourceDefinition.PATH);
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    SharedStateCacheResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, CacheMode mode, FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(path, new ResourceDescriptorConfigurator(configurator), mode, executors);
        this.executors = executors;
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PartitionHandlingResourceDefinition().register(registration);
        new StateTransferResourceDefinition().register(registration);
        new BackupsResourceDefinition(this.executors).register(registration);
        return registration;
    }

    @Override
    public MapEntry<Consumer<ConfigurationBuilder>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String containerName = address.getParent().getLastElement().getValue();
        String cacheName = address.getLastElement().getValue();
        final ServiceDependency partitionHandling = ServiceDependency.on(PartitionHandlingResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency stateTransfer = ServiceDependency.on(StateTransferResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency backups = ServiceDependency.on(BackupsResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        return super.resolve(context, model).map(consumer -> consumer.andThen(new Consumer<ConfigurationBuilder>(){

            @Override
            public void accept(ConfigurationBuilder builder) {
                builder.clustering().partitionHandling().read((Object)((PartitionHandlingConfiguration)partitionHandling.get()));
                builder.clustering().stateTransfer().read((Object)((StateTransferConfiguration)stateTransfer.get()));
                SitesConfigurationBuilder sitesBuilder = builder.sites();
                sitesBuilder.read((Object)((SitesConfiguration)backups.get()));
            }
        }), stream -> Stream.concat(stream, Stream.of(partitionHandling, stateTransfer, backups)));
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addRequiredChildren(REQUIRED_CHILDREN);
        }
    }
}

