/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AssociationOverrides;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Cacheable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.ConcreteProxy;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.QueryCacheLayout;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLDeletes;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLInserts;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SQLUpdates;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.annotations.SecondaryRows;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.View;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CreateKeySecondPass;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.IndexBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.JoinedSubclassFkSecondPass;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.NullableDiscriminatorColumnSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.boot.model.internal.SecondaryTableSecondPass;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jpa.event.internal.CallbackDefinitionResolverLegacyImpl;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class EntityBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityBinder.class.getName());
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private MetadataBuildingContext context;
    private String name;
    private XClass annotatedClass;
    private PersistentClass persistentClass;
    private PolymorphismType polymorphismType;
    private boolean lazy;
    private XClass proxyClass;
    private String where;
    private final Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private final Map<String, Join> secondaryTablesFromAnnotation = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableFromAnnotationJoins = new HashMap<String, Object>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private boolean ignoreIdAnnotations;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;
    private CacheLayout queryCacheLayout;

    public static void bindEntityClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, MetadataBuildingContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStates.get(clazzToProcess);
        PersistentClass superEntity = EntityBinder.getSuperEntity(clazzToProcess, inheritanceStates, context, inheritanceState);
        PersistentClass persistentClass = EntityBinder.makePersistentClass(inheritanceState, superEntity, context);
        EntityBinder.checkOverrides(clazzToProcess, superEntity);
        EntityBinder entityBinder = new EntityBinder(clazzToProcess, persistentClass, context);
        entityBinder.bindEntity();
        entityBinder.bindSubselect();
        entityBinder.bindTables(inheritanceState, superEntity);
        entityBinder.bindCustomSql();
        entityBinder.bindSynchronize();
        entityBinder.bindFilters();
        entityBinder.handleCheckConstraints();
        PropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, context, inheritanceStates);
        entityBinder.handleInheritance(inheritanceState, superEntity, holder);
        entityBinder.handleIdentifier(holder, inheritanceStates, generators, inheritanceState);
        InFlightMetadataCollector collector = context.getMetadataCollector();
        if (persistentClass instanceof RootClass) {
            collector.addSecondPass(new CreateKeySecondPass((RootClass)persistentClass));
            EntityBinder.bindSoftDelete(clazzToProcess, (RootClass)persistentClass, context);
        }
        if (persistentClass instanceof Subclass) {
            assert (superEntity != null);
            superEntity.addSubclass((Subclass)persistentClass);
        }
        collector.addEntityBinding(persistentClass);
        collector.addSecondPass(new SecondaryTableFromAnnotationSecondPass(entityBinder, holder, (XAnnotatedElement)clazzToProcess));
        collector.addSecondPass(new SecondaryTableSecondPass(entityBinder, holder, (XAnnotatedElement)clazzToProcess));
        entityBinder.processComplementaryTableDefinitions();
        EntityBinder.bindCallbacks(clazzToProcess, persistentClass, context);
        entityBinder.callTypeBinders(persistentClass);
    }

    private void bindTables(InheritanceState inheritanceState, PersistentClass superEntity) {
        this.handleClassTable(inheritanceState, superEntity);
        this.handleSecondaryTables();
    }

    private static void checkOverrides(XClass clazzToProcess, PersistentClass superEntity) {
        if (superEntity != null) {
            AssociationOverride override;
            AttributeOverrides overrides = (AttributeOverrides)clazzToProcess.getAnnotation(AttributeOverrides.class);
            if (overrides != null) {
                for (AttributeOverride override2 : overrides.value()) {
                    EntityBinder.checkOverride(superEntity, override2.name(), clazzToProcess, AttributeOverride.class);
                }
            }
            if ((override = (AssociationOverride)clazzToProcess.getAnnotation(AttributeOverride.class)) != null) {
                EntityBinder.checkOverride(superEntity, override.name(), clazzToProcess, AttributeOverride.class);
            }
            if ((overrides = (AssociationOverrides)clazzToProcess.getAnnotation(AssociationOverrides.class)) != null) {
                override = overrides.value();
                int n = ((AssociationOverride[])override).length;
                for (int i = 0; i < n; ++i) {
                    AttributeOverride override2;
                    override2 = override[i];
                    EntityBinder.checkOverride(superEntity, override2.name(), clazzToProcess, AssociationOverride.class);
                }
            }
            if ((override = (AssociationOverride)clazzToProcess.getAnnotation(AssociationOverride.class)) != null) {
                EntityBinder.checkOverride(superEntity, override.name(), clazzToProcess, AssociationOverride.class);
            }
        }
    }

    private static void checkOverride(PersistentClass superEntity, String name, XClass clazzToProcess, Class<?> overrideClass) {
        if (superEntity.hasProperty(StringHelper.root(name))) {
            throw new AnnotationException("Property '" + name + "' is inherited from entity '" + superEntity.getEntityName() + "' and may not be overridden using '@" + overrideClass.getSimpleName() + "' in entity subclass '" + clazzToProcess.getName() + "'");
        }
    }

    private static void bindSoftDelete(XClass xClass, RootClass rootClass, MetadataBuildingContext context) {
        SoftDelete softDelete = EntityBinder.extractSoftDelete(xClass, rootClass, context);
        if (softDelete != null) {
            SoftDeleteHelper.bindSoftDeleteIndicator(softDelete, rootClass, rootClass.getRootTable(), context);
        }
    }

    private static SoftDelete extractSoftDelete(XClass xClass, RootClass rootClass, MetadataBuildingContext context) {
        SoftDelete fromClass = (SoftDelete)xClass.getAnnotation(SoftDelete.class);
        if (fromClass != null) {
            return fromClass;
        }
        for (MappedSuperclass mappedSuperclass = rootClass.getSuperMappedSuperclass(); mappedSuperclass != null; mappedSuperclass = mappedSuperclass.getSuperMappedSuperclass()) {
            SoftDelete fromMappedSuperclass = mappedSuperclass.getMappedClass().getAnnotation(SoftDelete.class);
            if (fromMappedSuperclass == null) continue;
            return fromMappedSuperclass;
        }
        return BinderHelper.extractFromPackage(SoftDelete.class, xClass, context);
    }

    private void handleCheckConstraints() {
        if (this.annotatedClass.isAnnotationPresent(Checks.class)) {
            for (Check check : ((Checks)this.annotatedClass.getAnnotation(Checks.class)).value()) {
                this.addCheckToEntity(check);
            }
        } else {
            Check check = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, Check.class, this.context);
            if (check != null) {
                this.addCheckToEntity(check);
            }
        }
    }

    private void addCheckToEntity(Check check) {
        String name = check.name();
        String constraint = check.constraints();
        this.persistentClass.addCheckConstraint(name.isEmpty() ? new CheckConstraint(constraint) : new CheckConstraint(name, constraint));
    }

    private void callTypeBinders(PersistentClass persistentClass) {
        for (Annotation containingAnnotation : HCANNHelper.findContainingAnnotations((XAnnotatedElement)this.annotatedClass, TypeBinderType.class)) {
            TypeBinderType binderType = containingAnnotation.annotationType().getAnnotation(TypeBinderType.class);
            try {
                TypeBinder<?> binder = binderType.binder().newInstance();
                binder.bind(containingAnnotation, this.context, persistentClass);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @TypeBinderType annotation '" + containingAnnotation + "'", e);
            }
        }
    }

    private void handleIdentifier(PropertyHolder propertyHolder, Map<XClass, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, InheritanceState inheritanceState) {
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.postProcess(this.persistentClass, this);
        Set<String> idPropertiesIfIdClass = this.handleIdClass(this.persistentClass, inheritanceState, this.context, propertyHolder, elementsToProcess, inheritanceStates);
        this.processIdPropertiesIfNotAlready(this.persistentClass, inheritanceState, this.context, propertyHolder, generators, idPropertiesIfIdClass, elementsToProcess, inheritanceStates);
    }

    private void processComplementaryTableDefinitions() {
        this.processComplementaryTableDefinitions((org.hibernate.annotations.Table)this.annotatedClass.getAnnotation(org.hibernate.annotations.Table.class));
        this.processComplementaryTableDefinitions((Tables)this.annotatedClass.getAnnotation(Tables.class));
        this.processComplementaryTableDefinitions((Table)this.annotatedClass.getAnnotation(Table.class));
    }

    private Set<String> handleIdClass(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Map<XClass, InheritanceState> inheritanceStates) {
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = this.mapAsIdClass(inheritanceStates, inheritanceState, persistentClass, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context);
        if (!isIdClass) {
            this.setWrapIdsInEmbeddedComponents(elementsToProcess.getIdPropertyCount() > 1);
        }
        return idPropertiesIfIdClass;
    }

    private boolean mapAsIdClass(Map<XClass, InheritanceState> inheritanceStates, InheritanceState inheritanceState, PersistentClass persistentClass, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context) {
        XClass classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            AccessType propertyAccessor;
            PropertyPreloadedData baseInferredData;
            AccessType accessType;
            PropertyPreloadedData inferredData;
            Class idClassValue = ((IdClass)classWithIdClass.getAnnotation(IdClass.class)).value();
            XClass compositeClass = context.getBootstrapContext().getReflectionManager().toXClass(idClassValue);
            boolean isFakeIdClass = EntityBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, compositeClass, inferredData = new PropertyPreloadedData(accessType = this.getPropertyAccessType(), "id", compositeClass), baseInferredData = new PropertyPreloadedData(accessType, "id", classWithIdClass), propertyAccessor = this.getPropertyAccessor((XAnnotatedElement)compositeClass), inheritanceStates, context);
            if (isFakeIdClass) {
                return false;
            }
            boolean ignoreIdAnnotations = this.isIgnoreIdAnnotations();
            this.setIgnoreIdAnnotations(true);
            Component idClassComponent = this.bindIdClass(inferredData, baseInferredData, propertyHolder, propertyAccessor, context, inheritanceStates);
            Component mapper = this.createMapperProperty(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, compositeClass, baseInferredData, propertyAccessor, true);
            if (idClassComponent.isSimpleRecord()) {
                mapper.setSimpleRecord(true);
            }
            this.setIgnoreIdAnnotations(ignoreIdAnnotations);
            for (Property property : mapper.getProperties()) {
                idPropertiesIfIdClass.add(property.getName());
            }
            return true;
        }
        return false;
    }

    private Component createMapperProperty(Map<XClass, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, XClass classWithIdClass, XClass compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = this.createMapper(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, compositeClass, baseInferredData, propertyAccessor, isIdClass);
        Property mapperProperty = new Property();
        mapperProperty.setName("_identifierMapper");
        mapperProperty.setUpdateable(false);
        mapperProperty.setInsertable(false);
        mapperProperty.setPropertyAccessorName("embedded");
        mapperProperty.setValue(mapper);
        persistentClass.addProperty(mapperProperty);
        return mapper;
    }

    private Component createMapper(Map<XClass, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, XClass classWithIdClass, XClass compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = EmbeddableBinder.fillEmbeddable(propertyHolder, new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass), baseInferredData, propertyAccessor, false, this, true, true, false, null, null, null, context, inheritanceStates, isIdClass);
        persistentClass.setIdentifierMapper(mapper);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(classWithIdClass, inheritanceStates, context);
        if (superclass != null) {
            superclass.setDeclaredIdentifierMapper(mapper);
        } else {
            persistentClass.setDeclaredIdentifierMapper(mapper);
        }
        return mapper;
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElement(), inferredData.getPropertyClass(), propertyAccessor);
        PropertyBinder.addElementsOfClass(baseClassElements, propContainer, context);
        return (PropertyData)baseClassElements.get(0);
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, XClass compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<XClass, InheritanceState> inheritanceStates, MetadataBuildingContext context) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = EntityBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, context);
            InheritanceState state = inheritanceStates.get(idPropertyOnBaseClass.getClassOrElement());
            if (state == null) {
                return false;
            }
            XClass associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                return BinderHelper.hasToOneAnnotation((XAnnotatedElement)idPropertyOnBaseClass.getProperty());
            }
            IdClass idClass = (IdClass)associatedClassWithIdClass.getAnnotation(IdClass.class);
            return context.getBootstrapContext().getReflectionManager().toXClass(idClass.value()).equals(compositeClass);
        }
        return false;
    }

    private Component bindIdClass(PropertyData inferredData, PropertyData baseInferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, MetadataBuildingContext buildingContext, Map<XClass, InheritanceState> inheritanceStates) {
        propertyHolder.setInIdClass(true);
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' is a subclass in an entity inheritance hierarchy and may not redefine the identifier of the root entity");
        }
        RootClass rootClass = (RootClass)persistentClass;
        Component id = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, this, true, false, false, null, null, null, buildingContext, inheritanceStates, true);
        id.setKey(true);
        if (rootClass.getIdentifier() != null) {
            throw new AssertionFailure("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' and may not have an identifier property");
        }
        if (id.getPropertySpan() == 0) {
            throw new AnnotationException("Class '" + id.getComponentClassName() + " is the '@IdClass' for the entity '" + persistentClass.getEntityName() + "' but has no persistent properties");
        }
        rootClass.setIdentifier(id);
        EntityBinder.handleIdGenerator(inferredData, buildingContext, id);
        rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
        propertyHolder.setInIdClass(null);
        return id;
    }

    private static void handleIdGenerator(PropertyData inferredData, MetadataBuildingContext buildingContext, Component id) {
        if (buildingContext.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            buildingContext.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass(id, inferredData.getProperty(), "assigned", "", buildingContext));
        } else {
            GeneratorBinder.makeIdGenerator((SimpleValue)id, inferredData.getProperty(), "assigned", "", buildingContext, Collections.emptyMap());
        }
    }

    private void handleSecondaryTables() {
        SecondaryTable secTable = (SecondaryTable)this.annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTables = (SecondaryTables)this.annotatedClass.getAnnotation(SecondaryTables.class);
        if (secTables != null) {
            for (SecondaryTable tab : secTables.value()) {
                this.addJoin(tab, null, false);
            }
        } else if (secTable != null) {
            this.addJoin(secTable, null, false);
        }
    }

    private void handleClassTable(InheritanceState inheritanceState, PersistentClass superEntity) {
        UniqueConstraint[] uniqueConstraints;
        String catalog;
        String schema;
        String table;
        boolean hasTableAnnotation = this.annotatedClass.isAnnotationPresent(Table.class);
        if (hasTableAnnotation) {
            Table tableAnnotation = (Table)this.annotatedClass.getAnnotation(Table.class);
            table = tableAnnotation.name();
            schema = tableAnnotation.schema();
            catalog = tableAnnotation.catalog();
            uniqueConstraints = tableAnnotation.uniqueConstraints();
        } else {
            schema = "";
            table = "";
            catalog = "";
            uniqueConstraints = new UniqueConstraint[]{};
        }
        if (inheritanceState.hasTable()) {
            this.createTable(inheritanceState, superEntity, schema, table, catalog, uniqueConstraints);
        } else {
            if (hasTableAnnotation) {
                throw new AnnotationException("Entity '" + this.annotatedClass.getName() + "' is a subclass in a 'SINGLE_TABLE' hierarchy and may not be annotated '@Table' (the root class declares the table mapping for the hierarchy)");
            }
            this.bindTableForDiscriminatedSubclass(superEntity.getEntityName());
        }
    }

    private void createTable(InheritanceState inheritanceState, PersistentClass superEntity, String schema, String table, String catalog, UniqueConstraint[] uniqueConstraints) {
        RowId rowId = (RowId)this.annotatedClass.getAnnotation(RowId.class);
        View view = (View)this.annotatedClass.getAnnotation(View.class);
        this.bindTable(schema, catalog, table, uniqueConstraints, rowId == null ? null : rowId.value(), view == null ? null : view.query(), inheritanceState.hasDenormalizedTable() ? this.context.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()) : null);
    }

    private void handleInheritance(InheritanceState inheritanceState, PersistentClass superEntity, PropertyHolder propertyHolder) {
        boolean isJoinedSubclass;
        switch (inheritanceState.getType()) {
            case JOINED: {
                this.joinedInheritance(inheritanceState, superEntity, propertyHolder);
                isJoinedSubclass = inheritanceState.hasParents();
                break;
            }
            case SINGLE_TABLE: {
                this.singleTableInheritance(inheritanceState, propertyHolder);
                isJoinedSubclass = false;
                break;
            }
            case TABLE_PER_CLASS: {
                isJoinedSubclass = false;
                break;
            }
            default: {
                throw new AssertionFailure("Unrecognized InheritanceType");
            }
        }
        this.bindDiscriminatorValue();
        if (!isJoinedSubclass) {
            this.checkNoJoinColumns();
            this.checkNoOnDelete();
        }
    }

    private void singleTableInheritance(InheritanceState inheritanceState, PropertyHolder holder) {
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processSingleTableDiscriminatorProperties(inheritanceState);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (inheritanceState.hasSiblings() || discriminatorColumn != null && !discriminatorColumn.isImplicit()) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void joinedInheritance(InheritanceState state, PersistentClass superEntity, PropertyHolder holder) {
        if (state.hasParents()) {
            AnnotatedJoinColumns joinColumns = EntityBinder.subclassJoinColumns(this.annotatedClass, superEntity, this.context);
            JoinedSubclass jsc = (JoinedSubclass)this.persistentClass;
            DependantValue key = new DependantValue(this.context, jsc.getTable(), jsc.getIdentifier());
            jsc.setKey(key);
            EntityBinder.handleForeignKeys(this.annotatedClass, this.context, key);
            OnDelete onDelete = (OnDelete)this.annotatedClass.getAnnotation(OnDelete.class);
            key.setOnDeleteAction(onDelete == null ? null : onDelete.action());
            this.context.getMetadataCollector().addSecondPass(new JoinedSubclassFkSecondPass(jsc, joinColumns, key, this.context));
            this.context.getMetadataCollector().addSecondPass(new CreateKeySecondPass(jsc));
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processJoinedDiscriminatorProperties(state);
        if (!state.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (discriminatorColumn != null && (state.hasSiblings() || !discriminatorColumn.isImplicit())) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void checkNoJoinColumns() {
        if (this.annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumns.class) || this.annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' may not specify a '@PrimaryKeyJoinColumn'");
        }
    }

    private void checkNoOnDelete() {
        if (this.annotatedClass.isAnnotationPresent(OnDelete.class)) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' may not be annotated '@OnDelete'");
        }
    }

    private static void handleForeignKeys(XClass clazzToProcess, MetadataBuildingContext context, DependantValue key) {
        PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class);
        PrimaryKeyJoinColumns pkJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
        boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
        if (pkJoinColumn != null && BinderHelper.noConstraint(pkJoinColumn.foreignKey(), noConstraintByDefault) || pkJoinColumns != null && BinderHelper.noConstraint(pkJoinColumns.foreignKey(), noConstraintByDefault)) {
            key.disableForeignKey();
        } else {
            ForeignKey fk = (ForeignKey)clazzToProcess.getAnnotation(ForeignKey.class);
            if (fk != null && StringHelper.isNotEmpty(fk.name())) {
                key.setForeignKeyName(fk.name());
            } else {
                jakarta.persistence.ForeignKey foreignKey = (jakarta.persistence.ForeignKey)clazzToProcess.getAnnotation(jakarta.persistence.ForeignKey.class);
                if (BinderHelper.noConstraint(foreignKey, noConstraintByDefault)) {
                    key.disableForeignKey();
                } else if (foreignKey != null) {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                } else if (noConstraintByDefault) {
                    key.disableForeignKey();
                } else if (pkJoinColumns != null) {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(pkJoinColumns.foreignKey().name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(pkJoinColumns.foreignKey().foreignKeyDefinition()));
                } else if (pkJoinColumn != null) {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(pkJoinColumn.foreignKey().name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(pkJoinColumn.foreignKey().foreignKeyDefinition()));
                }
            }
        }
    }

    private void bindDiscriminatorColumnToRootPersistentClass(RootClass rootClass, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            AnnotatedColumns columns = new AnnotatedColumns();
            columns.setPropertyHolder(holder);
            columns.setBuildingContext(this.context);
            columns.setJoins(this.secondaryTables);
            discriminatorColumn.setParent(columns);
            BasicValue discriminatorColumnBinding = new BasicValue(this.context, rootClass.getTable());
            rootClass.setDiscriminator(discriminatorColumnBinding);
            discriminatorColumn.linkWithValue(discriminatorColumnBinding);
            discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            String rootEntityName = rootClass.getEntityName();
            LOG.tracev("Setting discriminator for entity {0}", rootEntityName);
            this.context.getMetadataCollector().addSecondPass(new NullableDiscriminatorColumnSecondPass(rootEntityName));
        }
    }

    private AnnotatedDiscriminatorColumn processSingleTableDiscriminatorProperties(InheritanceState inheritanceState) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorFormula discriminatorFormula = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, DiscriminatorFormula.class, this.context);
        if (!inheritanceState.hasParents() || this.annotatedClass.isAnnotationPresent(Inheritance.class)) {
            return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, discriminatorFormula, null, "DTYPE", this.context);
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        if (discriminatorFormula != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorFormula' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private AnnotatedDiscriminatorColumn processJoinedDiscriminatorProperties(InheritanceState inheritanceState) {
        if (this.annotatedClass.isAnnotationPresent(DiscriminatorFormula.class)) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' has 'JOINED' inheritance and is annotated '@DiscriminatorFormula'");
        }
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotation(DiscriminatorColumn.class);
        if (!inheritanceState.hasParents() || this.annotatedClass.isAnnotationPresent(Inheritance.class)) {
            return this.useDiscriminatorColumnForJoined(discriminatorColumn) ? AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, null, null, "DTYPE", this.context) : null;
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private boolean useDiscriminatorColumnForJoined(DiscriminatorColumn discriminatorColumn) {
        if (discriminatorColumn != null) {
            boolean ignore = this.context.getBuildingOptions().ignoreExplicitDiscriminatorsForJoinedInheritance();
            if (ignore) {
                LOG.debugf("Ignoring explicit @DiscriminatorColumn annotation on: %s", this.annotatedClass.getName());
            }
            return !ignore;
        }
        boolean createImplicit = this.context.getBuildingOptions().createImplicitDiscriminatorsForJoinedInheritance();
        if (createImplicit) {
            LOG.debugf("Inferring implicit @DiscriminatorColumn using defaults for: %s", this.annotatedClass.getName());
        }
        return createImplicit;
    }

    private void processIdPropertiesIfNotAlready(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> generators, Set<String> idPropertiesIfIdClass, InheritanceState.ElementsToProcess elementsToProcess, Map<XClass, InheritanceState> inheritanceStates) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        HashSet<String> missingEntityProperties = new HashSet<String>();
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                boolean subclassAndSingleTableStrategy;
                XProperty property = propertyAnnotatedElement.getProperty();
                boolean hasIdAnnotation = PropertyBinder.hasIdAnnotation((XAnnotatedElement)property);
                if (!idPropertiesIfIdClass.isEmpty() && !this.isIgnoreIdAnnotations() && hasIdAnnotation) {
                    missingEntityProperties.add(propertyName);
                    continue;
                }
                boolean bl = subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
                if (!hasIdAnnotation && property.isAnnotationPresent(GeneratedValue.class)) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, propertyAnnotatedElement) + "' is annotated @GeneratedValue but is not part of an identifier");
                }
                PropertyBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, generators, this, false, false, false, context, inheritanceStates);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (!missingIdProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' with properties " + EntityBinder.getMissingPropertiesString(missingIdProperties) + " which do not match properties of the entity class");
        }
        if (!missingEntityProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has '@Id' annotated properties " + EntityBinder.getMissingPropertiesString(missingEntityProperties) + " which do not match properties of the specified '@IdClass'");
        }
    }

    private static String getMissingPropertiesString(Set<String> propertyNames) {
        StringBuilder sb = new StringBuilder();
        for (String property : propertyNames) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'").append(property).append("'");
        }
        return sb.toString();
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass(metadataBuildingContext);
        }
        switch (inheritanceState.getType()) {
            case SINGLE_TABLE: {
                return new SingleTableSubclass(superEntity, metadataBuildingContext);
            }
            case JOINED: {
                return new JoinedSubclass(superEntity, metadataBuildingContext);
            }
            case TABLE_PER_CLASS: {
                return new UnionSubclass(superEntity, metadataBuildingContext);
            }
        }
        throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
    }

    private static AnnotatedJoinColumns subclassJoinColumns(XClass clazzToProcess, PersistentClass superEntity, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
        if (primaryKeyJoinColumns != null) {
            PrimaryKeyJoinColumn[] columns = primaryKeyJoinColumns.value();
            if (columns.length > 0) {
                for (PrimaryKeyJoinColumn column : columns) {
                    AnnotatedJoinColumn.buildInheritanceJoinColumn(column, null, superEntity.getIdentifier(), joinColumns, context);
                }
            } else {
                AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class), null, superEntity.getIdentifier(), joinColumns, context);
            }
        } else {
            AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class), null, superEntity.getIdentifier(), joinColumns, context);
        }
        LOG.trace("Subclass joined column(s) created");
        return joinColumns;
    }

    private static PersistentClass getSuperEntity(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStates, MetadataBuildingContext context, InheritanceState inheritanceState) {
        InheritanceState superState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStates);
        if (superState == null) {
            return null;
        }
        PersistentClass superEntity = context.getMetadataCollector().getEntityBinding(superState.getClazz().getName());
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be bound after its parent class: " + superState.getClazz().getName());
        }
        return superEntity;
    }

    private static void bindCallbacks(XClass entityClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        ReflectionManager reflection = context.getBootstrapContext().getReflectionManager();
        for (CallbackType callbackType : CallbackType.values()) {
            persistentClass.addCallbackDefinitions(CallbackDefinitionResolverLegacyImpl.resolveEntityCallbacks(reflection, entityClass, callbackType));
        }
        context.getMetadataCollector().addSecondPass(persistentClasses -> {
            for (Property property : persistentClass.getDeclaredProperties()) {
                Class<?> mappedClass = persistentClass.getMappedClass();
                if (!property.isComposite()) continue;
                for (CallbackType type : CallbackType.values()) {
                    property.addCallbackDefinitions(CallbackDefinitionResolverLegacyImpl.resolveEmbeddableCallbacks(reflection, mappedClass, property, type));
                }
            }
        });
    }

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder() {
    }

    public EntityBinder(XClass annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.persistentClass != null && this.persistentClass.isPropertyDefinedInSuperHierarchy(name);
    }

    private void bindRowManagement() {
        DynamicInsert dynamicInsertAnn = (DynamicInsert)this.annotatedClass.getAnnotation(DynamicInsert.class);
        this.persistentClass.setDynamicInsert(dynamicInsertAnn != null && dynamicInsertAnn.value());
        DynamicUpdate dynamicUpdateAnn = (DynamicUpdate)this.annotatedClass.getAnnotation(DynamicUpdate.class);
        this.persistentClass.setDynamicUpdate(dynamicUpdateAnn != null && dynamicUpdateAnn.value());
        if (this.persistentClass.useDynamicInsert() && this.annotatedClass.isAnnotationPresent(SQLInsert.class)) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicInsert' and '@SQLInsert'");
        }
        if (this.persistentClass.useDynamicUpdate() && this.annotatedClass.isAnnotationPresent(SQLUpdate.class)) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicUpdate' and '@SQLUpdate'");
        }
        SelectBeforeUpdate selectBeforeUpdateAnn = (SelectBeforeUpdate)this.annotatedClass.getAnnotation(SelectBeforeUpdate.class);
        this.persistentClass.setSelectBeforeUpdate(selectBeforeUpdateAnn != null && selectBeforeUpdateAnn.value());
    }

    private void bindOptimisticLocking() {
        OptimisticLocking optimisticLockingAnn = (OptimisticLocking)this.annotatedClass.getAnnotation(OptimisticLocking.class);
        this.persistentClass.setOptimisticLockStyle(OptimisticLockStyle.fromLockType(optimisticLockingAnn == null ? OptimisticLockType.VERSION : optimisticLockingAnn.type()));
    }

    private void bindPolymorphism() {
        Polymorphism polymorphismAnn = (Polymorphism)this.annotatedClass.getAnnotation(Polymorphism.class);
        this.polymorphismType = polymorphismAnn == null ? PolymorphismType.IMPLICIT : polymorphismAnn.type();
    }

    private void bindEntityAnnotation() {
        Entity entity = (Entity)this.annotatedClass.getAnnotation(Entity.class);
        if (entity == null) {
            throw new AssertionFailure("@Entity should never be missing");
        }
        String entityName = entity.name();
        this.name = entityName.isEmpty() ? StringHelper.unqualify(this.annotatedClass.getName()) : entityName;
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void bindEntity() {
        this.bindEntityAnnotation();
        this.bindRowManagement();
        this.bindOptimisticLocking();
        this.bindPolymorphism();
        this.bindProxy();
        this.bindConcreteProxy();
        this.bindWhere();
        this.bindCache();
        this.bindNaturalIdCache();
        this.bindFiltersInHierarchy();
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.persistentClass.setCached(this.isCached);
        this.persistentClass.setLazy(this.lazy);
        this.persistentClass.setQueryCacheLayout(this.queryCacheLayout);
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        if (this.persistentClass instanceof RootClass) {
            this.bindRootEntity();
        } else if (!this.isMutable()) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@Immutable' but it is a subclass in an entity inheritance hierarchy (only root classes may declare mutability)");
        }
        this.ensureNoMutabilityPlan();
        this.bindCustomPersister();
        this.bindCustomLoader();
        this.registerImportName();
        this.processNamedEntityGraphs();
    }

    private void ensureNoMutabilityPlan() {
        if (this.annotatedClass.isAnnotationPresent(Mutability.class)) {
            throw new MappingException("@Mutability is not allowed on entity");
        }
    }

    private boolean isMutable() {
        return !this.annotatedClass.isAnnotationPresent(Immutable.class);
    }

    private void registerImportName() {
        LOG.debugf("Import with entity name %s", this.name);
        try {
            this.context.getMetadataCollector().addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.context.getMetadataCollector().addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
    }

    private void bindRootEntity() {
        RootClass rootClass = (RootClass)this.persistentClass;
        rootClass.setMutable(this.isMutable());
        rootClass.setExplicitPolymorphism(this.polymorphismType == PolymorphismType.EXPLICIT);
        if (StringHelper.isNotEmpty(this.where)) {
            rootClass.setWhere(this.where);
        }
        if (this.cacheConcurrentStrategy != null) {
            rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
            rootClass.setCacheRegionName(this.cacheRegion);
            rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
        }
        rootClass.setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
    }

    private void bindCustomSql() {
        HQLSelect hqlSelect;
        SQLDeleteAll sqlDeleteAll;
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        String primaryTableName = this.persistentClass.getTable().getName();
        SQLInsert sqlInsert = this.findMatchingSqlAnnotation(primaryTableName, SQLInsert.class, SQLInserts.class);
        if (sqlInsert == null) {
            sqlInsert = this.findMatchingSqlAnnotation("", SQLInsert.class, SQLInserts.class);
        }
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            if (sqlInsert.verify() != Expectation.class) {
                this.persistentClass.setInsertExpectation(ReflectHelper.getDefaultSupplier(sqlInsert.verify()));
            }
        }
        if ((sqlUpdate = this.findMatchingSqlAnnotation(primaryTableName, SQLUpdate.class, SQLUpdates.class)) == null) {
            sqlUpdate = this.findMatchingSqlAnnotation("", SQLUpdate.class, SQLUpdates.class);
        }
        if (sqlUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            if (sqlUpdate.verify() != Expectation.class) {
                this.persistentClass.setUpdateExpectation(ReflectHelper.getDefaultSupplier(sqlUpdate.verify()));
            }
        }
        if ((sqlDelete = this.findMatchingSqlAnnotation(primaryTableName, SQLDelete.class, SQLDeletes.class)) == null) {
            sqlDelete = this.findMatchingSqlAnnotation("", SQLDelete.class, SQLDeletes.class);
        }
        if (sqlDelete != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            if (sqlDelete.verify() != Expectation.class) {
                this.persistentClass.setDeleteExpectation(ReflectHelper.getDefaultSupplier(sqlDelete.verify()));
            }
        }
        if ((sqlDeleteAll = (SQLDeleteAll)this.annotatedClass.getAnnotation(SQLDeleteAll.class)) != null) {
            throw new AnnotationException("@SQLDeleteAll does not apply to entities: " + this.persistentClass.getEntityName());
        }
        SQLSelect sqlSelect = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, SQLSelect.class, this.context);
        if (sqlSelect != null) {
            String loaderName = this.persistentClass.getEntityName() + "$SQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindNativeQuery(loaderName, sqlSelect, this.annotatedClass, this.context);
        }
        if ((hqlSelect = (HQLSelect)this.annotatedClass.getAnnotation(HQLSelect.class)) != null) {
            String loaderName = this.persistentClass.getEntityName() + "$HQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindQuery(loaderName, hqlSelect, this.context);
        }
    }

    private void bindCustomLoader() {
        Loader loader = (Loader)this.annotatedClass.getAnnotation(Loader.class);
        if (loader != null) {
            this.persistentClass.setLoaderName(loader.namedQuery());
        }
    }

    private void bindSubselect() {
        Subselect subselect = (Subselect)this.annotatedClass.getAnnotation(Subselect.class);
        if (subselect != null) {
            this.subselect = subselect.value();
        }
    }

    private void bindFilters() {
        for (Filter filter : this.filters) {
            String condition = filter.condition();
            if (condition.isEmpty()) {
                condition = this.getDefaultFilterCondition(filter.name());
            }
            this.persistentClass.addFilter(filter.name(), condition, filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
        }
    }

    private String getDefaultFilterCondition(String filterName) {
        FilterDefinition definition = this.context.getMetadataCollector().getFilterDefinition(filterName);
        if (definition == null) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' for an undefined filter named '" + filterName + "'");
        }
        String condition = definition.getDefaultFilterCondition();
        if (StringHelper.isEmpty(condition)) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' with no 'condition' and no default condition was given by the '@FilterDef' named '" + filterName + "'");
        }
        return condition;
    }

    private void bindSynchronize() {
        if (this.annotatedClass.isAnnotationPresent(Synchronize.class)) {
            JdbcEnvironment jdbcEnvironment = this.context.getMetadataCollector().getDatabase().getJdbcEnvironment();
            Synchronize synchronize = (Synchronize)this.annotatedClass.getAnnotation(Synchronize.class);
            for (String table : synchronize.value()) {
                String physicalName = synchronize.logical() ? this.toPhysicalName(jdbcEnvironment, table) : table;
                this.persistentClass.addSynchronizedTable(physicalName);
            }
        }
    }

    private String toPhysicalName(JdbcEnvironment jdbcEnvironment, String logicalName) {
        Identifier identifier = jdbcEnvironment.getIdentifierHelper().toIdentifier(logicalName);
        return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(identifier, jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    private void bindCustomPersister() {
        Persister persisterAnn = (Persister)this.annotatedClass.getAnnotation(Persister.class);
        if (persisterAnn != null) {
            Class<?> clazz = persisterAnn.impl();
            if (!EntityPersister.class.isAssignableFrom(clazz)) {
                throw new AnnotationException("Persister class '" + clazz.getName() + "' does not implement 'EntityPersister'");
            }
            this.persistentClass.setEntityPersisterClass(clazz);
        }
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    private void processNamedEntityGraphs() {
        this.processNamedEntityGraph((NamedEntityGraph)this.annotatedClass.getAnnotation(NamedEntityGraph.class));
        NamedEntityGraphs graphs = (NamedEntityGraphs)this.annotatedClass.getAnnotation(NamedEntityGraphs.class);
        if (graphs != null) {
            for (NamedEntityGraph graph : graphs.value()) {
                this.processNamedEntityGraph(graph);
            }
        }
    }

    private void processNamedEntityGraph(NamedEntityGraph annotation) {
        if (annotation == null) {
            return;
        }
        this.context.getMetadataCollector().addNamedEntityGraph(new NamedEntityGraphDefinition(annotation, this.name, this.persistentClass.getEntityName()));
    }

    public void bindDiscriminatorValue() {
        String discriminatorValue;
        String string = discriminatorValue = this.annotatedClass.isAnnotationPresent(DiscriminatorValue.class) ? ((DiscriminatorValue)this.annotatedClass.getAnnotation(DiscriminatorValue.class)).value() : null;
        if (StringHelper.isEmpty(discriminatorValue)) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(discriminator.getType().getName())) {
                    throw new AnnotationException("Entity '" + this.name + "' has a discriminator of character type and must specify its '@DiscriminatorValue'");
                }
                if ("integer".equals(discriminator.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(discriminatorValue);
        }
    }

    public void bindProxy() {
        Proxy proxy = (Proxy)this.annotatedClass.getAnnotation(Proxy.class);
        if (proxy != null) {
            this.lazy = proxy.lazy();
            this.proxyClass = this.lazy ? this.proxyClass(proxy) : null;
        } else {
            this.lazy = true;
            this.proxyClass = this.annotatedClass;
        }
    }

    private XClass proxyClass(Proxy proxy) {
        ReflectionManager reflectionManager = this.context.getBootstrapContext().getReflectionManager();
        XClass proxyClass = reflectionManager.toXClass(proxy.proxyClass());
        return BinderHelper.isDefault(proxyClass, this.context) ? this.annotatedClass : proxyClass;
    }

    public void bindConcreteProxy() {
        ConcreteProxy concreteProxy = (ConcreteProxy)this.annotatedClass.getAnnotation(ConcreteProxy.class);
        if (concreteProxy != null) {
            if (this.persistentClass.getSuperclass() != null) {
                throw new AnnotationException("Entity class '" + this.persistentClass.getClassName() + "' is annotated '@ConcreteProxy' but it is not the root of the entity inheritance hierarchy");
            }
            this.persistentClass.getRootClass().setConcreteProxy(true);
        }
    }

    public void bindWhere() {
        SQLRestriction restriction;
        Where where = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, Where.class, this.context);
        if (where != null) {
            this.where = where.clause();
        }
        if ((restriction = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, SQLRestriction.class, this.context)) != null) {
            this.where = restriction.value();
        }
    }

    public void setWrapIdsInEmbeddedComponents(boolean wrapIdsInEmbeddedComponents) {
        this.wrapIdsInEmbeddedComponents = wrapIdsInEmbeddedComponents;
    }

    private void bindNaturalIdCache() {
        this.naturalIdCacheRegion = null;
        NaturalIdCache naturalIdCacheAnn = (NaturalIdCache)this.annotatedClass.getAnnotation(NaturalIdCache.class);
        if (naturalIdCacheAnn != null) {
            Cache explicitCacheAnn;
            this.naturalIdCacheRegion = naturalIdCacheAnn.region().isEmpty() ? ((explicitCacheAnn = (Cache)this.annotatedClass.getAnnotation(Cache.class)) != null && StringHelper.isNotEmpty(explicitCacheAnn.region()) ? explicitCacheAnn.region() + NATURAL_ID_CACHE_SUFFIX : this.annotatedClass.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCacheAnn.region();
        }
    }

    private void bindCache() {
        this.isCached = false;
        this.cacheConcurrentStrategy = null;
        this.cacheRegion = null;
        this.cacheLazyProperty = true;
        this.queryCacheLayout = null;
        SharedCacheMode sharedCacheMode = this.context.getBuildingOptions().getSharedCacheMode();
        if (this.persistentClass instanceof RootClass) {
            this.bindRootClassCache(sharedCacheMode, this.context);
        } else {
            this.bindSubclassCache(sharedCacheMode);
        }
    }

    private void bindSubclassCache(SharedCacheMode sharedCacheMode) {
        if (this.annotatedClass.isAnnotationPresent(Cache.class)) {
            String className = this.persistentClass.getClassName() == null ? this.annotatedClass.getName() : this.persistentClass.getClassName();
            throw new AnnotationException("Entity class '" + className + "' is annotated '@Cache' but it is a subclass in an entity inheritance hierarchy (only root classes may define second-level caching semantics)");
        }
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotation(Cacheable.class);
        this.isCached = cacheable == null && this.persistentClass.getSuperclass() != null ? this.persistentClass.getSuperclass().isCached() : EntityBinder.isCacheable(sharedCacheMode, cacheable);
    }

    private void bindRootClassCache(SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        Cache effectiveCache;
        Cache cache = (Cache)this.annotatedClass.getAnnotation(Cache.class);
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotation(Cacheable.class);
        if (cache != null) {
            this.isCached = true;
            effectiveCache = cache;
        } else {
            effectiveCache = EntityBinder.buildCacheMock(this.annotatedClass.getName(), context);
            this.isCached = EntityBinder.isCacheable(sharedCacheMode, cacheable);
        }
        this.cacheConcurrentStrategy = EntityBinder.resolveCacheConcurrencyStrategy(effectiveCache.usage());
        this.cacheRegion = effectiveCache.region();
        this.cacheLazyProperty = EntityBinder.isCacheLazy(effectiveCache, this.annotatedClass);
        QueryCacheLayout queryCache = (QueryCacheLayout)this.annotatedClass.getAnnotation(QueryCacheLayout.class);
        this.queryCacheLayout = queryCache == null ? null : queryCache.layout();
    }

    private static boolean isCacheLazy(Cache effectiveCache, XClass annotatedClass) {
        if (!effectiveCache.includeLazy()) {
            return false;
        }
        switch (effectiveCache.include().toLowerCase(Locale.ROOT)) {
            case "all": {
                return true;
            }
            case "non-lazy": {
                return false;
            }
        }
        throw new AnnotationException("Class '" + annotatedClass.getName() + "' has a '@Cache' with undefined option 'include=\"" + effectiveCache.include() + "\"'");
    }

    private static boolean isCacheable(SharedCacheMode sharedCacheMode, Cacheable explicitCacheableAnn) {
        switch (sharedCacheMode) {
            case ALL: {
                return true;
            }
            case ENABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return explicitCacheableAnn != null && explicitCacheableAnn.value();
            }
            case DISABLE_SELECTIVE: {
                return explicitCacheableAnn == null || explicitCacheableAnn.value();
            }
        }
        return false;
    }

    private static String resolveCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    private static Cache buildCacheMock(String region, MetadataBuildingContext context) {
        return new LocalCacheAnnotationStub(region, EntityBinder.determineCacheConcurrencyStrategy(context));
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(MetadataBuildingContext context) {
        return CacheConcurrencyStrategy.fromAccessType(context.getBuildingOptions().getImplicitCacheAccessType());
    }

    public void bindTableForDiscriminatedSubclass(String entityName) {
        if (!(this.persistentClass instanceof SingleTableSubclass)) {
            throw new AssertionFailure("Was expecting a discriminated subclass [" + SingleTableSubclass.class.getName() + "] but found [" + this.persistentClass.getClass().getName() + "] for entity [" + this.persistentClass.getEntityName() + "]");
        }
        InFlightMetadataCollector collector = this.context.getMetadataCollector();
        InFlightMetadataCollector.EntityTableXref superTableXref = collector.getEntityTableXref(entityName);
        org.hibernate.mapping.Table primaryTable = superTableXref.getPrimaryTable();
        collector.addEntityTableXref(this.persistentClass.getEntityName(), collector.getDatabase().toIdentifier(collector.getLogicalTableName(primaryTable)), primaryTable, superTableXref);
    }

    public void bindTable(String schema, String catalog, String tableName, UniqueConstraint[] uniqueConstraints, String rowId, String viewQuery, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        String entityName = this.persistentClass.getEntityName();
        EntityTableNamingStrategyHelper namingStrategyHelper = new EntityTableNamingStrategyHelper(this.persistentClass.getClassName(), entityName, this.name);
        Identifier logicalName = StringHelper.isNotEmpty(tableName) ? namingStrategyHelper.handleExplicitName(tableName, this.context) : namingStrategyHelper.determineImplicitName(this.context);
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName, this.persistentClass.isAbstract(), uniqueConstraints, this.context, this.subselect, denormalizedSuperTableXref);
        table.setRowId(rowId);
        table.setViewQuery(viewQuery);
        this.context.getMetadataCollector().addEntityTableXref(entityName, logicalName, table, denormalizedSuperTableXref);
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        LOG.debugf("Bind entity %s on table %s", entityName, table.getName());
        ((TableOwner)((Object)this.persistentClass)).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    public void finalSecondaryTableFromAnnotationBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableFromAnnotationJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (!this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    private void createPrimaryColumnsToSecondaryTable(Object column, PropertyHolder propertyHolder, Join join) {
        PrimaryKeyJoinColumn[] pkColumnsAnn = column instanceof PrimaryKeyJoinColumn[] ? (PrimaryKeyJoinColumn[])column : null;
        JoinColumn[] joinColumnsAnn = column instanceof JoinColumn[] ? (JoinColumn[])column : null;
        AnnotatedJoinColumns annotatedJoinColumns = pkColumnsAnn == null && joinColumnsAnn == null ? this.createDefaultJoinColumn(propertyHolder) : this.createJoinColumns(propertyHolder, pkColumnsAnn, joinColumnsAnn);
        for (AnnotatedJoinColumn joinColumn : annotatedJoinColumns.getJoinColumns()) {
            joinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, annotatedJoinColumns, this.context);
    }

    private AnnotatedJoinColumns createDefaultJoinColumn(PropertyHolder propertyHolder) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(this.context);
        joinColumns.setJoins(this.secondaryTables);
        joinColumns.setPropertyHolder(propertyHolder);
        AnnotatedJoinColumn.buildInheritanceJoinColumn(null, null, this.persistentClass.getIdentifier(), joinColumns, this.context);
        return joinColumns;
    }

    private AnnotatedJoinColumns createJoinColumns(PropertyHolder propertyHolder, PrimaryKeyJoinColumn[] primaryKeyJoinColumns, JoinColumn[] joinColumns) {
        int joinColumnCount;
        int n = joinColumnCount = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.length : joinColumns.length;
        if (joinColumnCount == 0) {
            return this.createDefaultJoinColumn(propertyHolder);
        }
        AnnotatedJoinColumns columns = new AnnotatedJoinColumns();
        columns.setBuildingContext(this.context);
        columns.setJoins(this.secondaryTables);
        columns.setPropertyHolder(propertyHolder);
        for (int colIndex = 0; colIndex < joinColumnCount; ++colIndex) {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns != null ? primaryKeyJoinColumns[colIndex] : null;
            JoinColumn joinColumn = joinColumns != null ? joinColumns[colIndex] : null;
            AnnotatedJoinColumn.buildInheritanceJoinColumn(primaryKeyJoinColumn, joinColumn, this.persistentClass.getIdentifier(), columns, this.context);
        }
        return columns;
    }

    private void bindJoinToPersistentClass(Join join, AnnotatedJoinColumns joinColumns, MetadataBuildingContext context) {
        DependantValue key = new DependantValue(context, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(key);
        this.setForeignKeyNameIfDefined(join);
        key.setOnDeleteAction(null);
        TableBinder.bindForeignKey(this.persistentClass, null, joinColumns, key, false, context);
        key.sortProperties();
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setForeignKeyNameIfDefined(Join join) {
        String tableName = join.getTable().getQuotedName();
        org.hibernate.annotations.Table matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        SimpleValue key = (SimpleValue)join.getKey();
        if (matchingTable != null && !matchingTable.foreignKey().name().isEmpty()) {
            key.setForeignKeyName(matchingTable.foreignKey().name());
        } else {
            SecondaryTable jpaSecondaryTable = this.findMatchingSecondaryTable(join);
            if (jpaSecondaryTable != null) {
                boolean noConstraintByDefault = this.context.getBuildingOptions().isNoConstraintByDefault();
                if (jpaSecondaryTable.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || jpaSecondaryTable.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                    key.disableForeignKey();
                } else {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().foreignKeyDefinition()));
                }
            }
        }
    }

    private SecondaryTable findMatchingSecondaryTable(Join join) {
        String nameToMatch = join.getTable().getQuotedName();
        SecondaryTable secondaryTable = (SecondaryTable)this.annotatedClass.getAnnotation(SecondaryTable.class);
        if (secondaryTable != null && nameToMatch.equals(secondaryTable.name())) {
            return secondaryTable;
        }
        SecondaryTables secondaryTables = (SecondaryTables)this.annotatedClass.getAnnotation(SecondaryTables.class);
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTablesEntry : secondaryTables.value()) {
                if (secondaryTablesEntry == null || !nameToMatch.equals(secondaryTablesEntry.name())) continue;
                return secondaryTablesEntry;
            }
        }
        return null;
    }

    private org.hibernate.annotations.Table findMatchingComplementaryTableAnnotation(String tableName) {
        org.hibernate.annotations.Table table = (org.hibernate.annotations.Table)this.annotatedClass.getAnnotation(org.hibernate.annotations.Table.class);
        if (table != null && tableName.equals(table.appliesTo())) {
            return table;
        }
        Tables tables = (Tables)this.annotatedClass.getAnnotation(Tables.class);
        if (tables != null) {
            for (org.hibernate.annotations.Table current : tables.value()) {
                if (!tableName.equals(current.appliesTo())) continue;
                return current;
            }
        }
        return null;
    }

    private SecondaryRow findMatchingSecondaryRowAnnotation(String tableName) {
        SecondaryRow row = (SecondaryRow)this.annotatedClass.getAnnotation(SecondaryRow.class);
        if (row != null && (row.table().isEmpty() || tableName.equals(row.table()))) {
            return row;
        }
        SecondaryRows tables = (SecondaryRows)this.annotatedClass.getAnnotation(SecondaryRows.class);
        if (tables != null) {
            for (SecondaryRow current : tables.value()) {
                if (!tableName.equals(current.table())) continue;
                return current;
            }
        }
        return null;
    }

    private <T extends Annotation, R extends Annotation> T findMatchingSqlAnnotation(String tableName, Class<T> annotationType, Class<R> repeatableType) {
        T sqlAnnotation = BinderHelper.getOverridableAnnotation((XAnnotatedElement)this.annotatedClass, annotationType, this.context);
        if (sqlAnnotation != null && tableName.equals(EntityBinder.tableMember(annotationType, sqlAnnotation))) {
            return sqlAnnotation;
        }
        Annotation repeatable = this.annotatedClass.getAnnotation(repeatableType);
        if (repeatable != null) {
            for (Annotation current : EntityBinder.valueMember(repeatableType, repeatable)) {
                Annotation sqlAnn = current;
                if (!tableName.equals(EntityBinder.tableMember(annotationType, sqlAnn))) continue;
                return (T)sqlAnn;
            }
        }
        return null;
    }

    private static <T extends Annotation> String tableMember(Class<T> annotationType, T sqlAnnotation) {
        if (SQLInsert.class == annotationType) {
            return ((SQLInsert)sqlAnnotation).table();
        }
        if (SQLUpdate.class == annotationType) {
            return ((SQLUpdate)sqlAnnotation).table();
        }
        if (SQLDelete.class == annotationType) {
            return ((SQLDelete)sqlAnnotation).table();
        }
        if (SQLDeleteAll.class == annotationType) {
            return ((SQLDeleteAll)sqlAnnotation).table();
        }
        throw new AssertionFailure("Unknown annotation type");
    }

    private static <T extends Annotation> Annotation[] valueMember(Class<T> repeatableType, T sqlAnnotation) {
        if (SQLInserts.class == repeatableType) {
            return ((SQLInserts)sqlAnnotation).value();
        }
        if (SQLUpdates.class == repeatableType) {
            return ((SQLUpdates)sqlAnnotation).value();
        }
        if (SQLDeletes.class == repeatableType) {
            return ((SQLDeletes)sqlAnnotation).value();
        }
        throw new AssertionFailure("Unknown annotation type");
    }

    public Join addJoin(JoinTable joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        return this.addJoin(holder, noDelayInPkColumnCreation, false, joinTable.name(), joinTable.schema(), joinTable.catalog(), joinTable.joinColumns(), joinTable.uniqueConstraints());
    }

    public Join addJoin(SecondaryTable secondaryTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, true, secondaryTable.name(), secondaryTable.schema(), secondaryTable.catalog(), secondaryTable.pkJoinColumns(), secondaryTable.uniqueConstraints());
        org.hibernate.mapping.Table table = join.getTable();
        new IndexBinder(this.context).bindIndexes(table, secondaryTable.indexes());
        return join;
    }

    private Join addJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, String name, String schema, String catalog, Object joinColumns, UniqueConstraint[] uniqueConstraints) {
        QualifiedTableName logicalName = this.logicalTableName(name, schema, catalog);
        return this.createJoin(propertyHolder, noDelayInPkColumnCreation, secondaryTable, joinColumns, logicalName, TableBinder.buildAndFillTable(schema, catalog, logicalName.getTableName(), false, uniqueConstraints, this.context));
    }

    private QualifiedTableName logicalTableName(String name, String schema, String catalog) {
        return new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.context.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(name));
    }

    Join createJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, Object joinColumns, QualifiedTableName logicalName, org.hibernate.mapping.Table table) {
        Join join = new Join();
        this.persistentClass.addJoin(join);
        String entityName = this.persistentClass.getEntityName();
        InFlightMetadataCollector.EntityTableXref tableXref = this.context.getMetadataCollector().getEntityTableXref(entityName);
        assert (tableXref != null) : "Could not locate EntityTableXref for entity [" + entityName + "]";
        tableXref.addSecondaryTable(logicalName, join);
        join.setTable(table);
        LOG.debugf("Adding secondary table to entity %s -> %s", entityName, join.getTable().getName());
        this.handleSecondaryRowManagement(join);
        this.processSecondaryTableCustomSql(join);
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            String quotedName = table.getQuotedName();
            if (secondaryTable) {
                this.secondaryTablesFromAnnotation.put(quotedName, join);
                this.secondaryTableFromAnnotationJoins.put(quotedName, joinColumns);
            } else {
                this.secondaryTableJoins.put(quotedName, joinColumns);
            }
            this.secondaryTables.put(quotedName, join);
        }
        return join;
    }

    private void handleSecondaryRowManagement(Join join) {
        String tableName = join.getTable().getQuotedName();
        org.hibernate.annotations.Table matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        SecondaryRow matchingRow = this.findMatchingSecondaryRowAnnotation(tableName);
        if (matchingRow != null) {
            join.setInverse(!matchingRow.owned());
            join.setOptional(matchingRow.optional());
        } else if (matchingTable != null) {
            join.setInverse(matchingTable.inverse());
            join.setOptional(matchingTable.optional());
        } else {
            join.setInverse(false);
            join.setOptional(true);
        }
    }

    private void processSecondaryTableCustomSql(Join join) {
        String deleteSql;
        SQLDelete sqlDelete;
        String updateSql;
        SQLUpdate sqlUpdate;
        String insertSql;
        String tableName = join.getTable().getQuotedName();
        org.hibernate.annotations.Table matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        SQLInsert sqlInsert = this.findMatchingSqlAnnotation(tableName, SQLInsert.class, SQLInserts.class);
        if (sqlInsert != null) {
            join.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            if (sqlInsert.verify() != Expectation.class) {
                join.setInsertExpectation(ReflectHelper.getDefaultSupplier(sqlInsert.verify()));
            }
        } else if (matchingTable != null && !(insertSql = matchingTable.sqlInsert().sql()).isEmpty()) {
            join.setCustomSQLInsert(insertSql.trim(), matchingTable.sqlInsert().callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(matchingTable.sqlInsert().check()));
        }
        if ((sqlUpdate = this.findMatchingSqlAnnotation(tableName, SQLUpdate.class, SQLUpdates.class)) != null) {
            join.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            if (sqlUpdate.verify() != Expectation.class) {
                join.setUpdateExpectation(ReflectHelper.getDefaultSupplier(sqlUpdate.verify()));
            }
        } else if (matchingTable != null && !(updateSql = matchingTable.sqlUpdate().sql()).isEmpty()) {
            join.setCustomSQLUpdate(updateSql.trim(), matchingTable.sqlUpdate().callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(matchingTable.sqlUpdate().check()));
        }
        if ((sqlDelete = this.findMatchingSqlAnnotation(tableName, SQLDelete.class, SQLDeletes.class)) != null) {
            join.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            if (sqlDelete.verify() != Expectation.class) {
                join.setDeleteExpectation(ReflectHelper.getDefaultSupplier(sqlDelete.verify()));
            }
        } else if (matchingTable != null && !(deleteSql = matchingTable.sqlDelete().sql()).isEmpty()) {
            join.setCustomSQLDelete(deleteSql.trim(), matchingTable.sqlDelete().callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(matchingTable.sqlDelete().check()));
        }
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean ignoreIdAnnotations) {
        this.ignoreIdAnnotations = ignoreIdAnnotations;
    }

    public void processComplementaryTableDefinitions(Table table) {
        if (table != null) {
            new IndexBinder(this.context).bindIndexes(this.persistentClass.getTable(), table.indexes());
        }
    }

    public void processComplementaryTableDefinitions(org.hibernate.annotations.Table table) {
        if (table != null) {
            org.hibernate.mapping.Table appliedTable = this.findTable(table.appliesTo());
            if (!table.comment().isEmpty()) {
                appliedTable.setComment(table.comment());
            }
            if (!table.checkConstraint().isEmpty()) {
                appliedTable.addCheckConstraint(table.checkConstraint());
            }
            TableBinder.addIndexes(appliedTable, table.indexes(), this.context);
        }
    }

    private org.hibernate.mapping.Table findTable(String tableName) {
        for (org.hibernate.mapping.Table table : this.persistentClass.getTableClosure()) {
            if (!table.getQuotedName().equals(tableName)) continue;
            return table;
        }
        for (Join join : this.secondaryTables.values()) {
            if (!join.getTable().getQuotedName().equals(tableName)) continue;
            return join.getTable();
        }
        throw new AnnotationException("Entity '" + this.name + "' has a '@org.hibernate.annotations.Table' annotation which 'appliesTo' an unknown table named '" + tableName + "'");
    }

    public void processComplementaryTableDefinitions(Tables tables) {
        if (tables != null) {
            for (org.hibernate.annotations.Table table : tables.value()) {
                this.processComplementaryTableDefinitions(table);
            }
        }
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType propertyAccessType) {
        this.propertyAccessType = this.getExplicitAccessType((XAnnotatedElement)this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = propertyAccessType;
        }
    }

    public AccessType getPropertyAccessor(XAnnotatedElement element) {
        AccessType accessType = this.getExplicitAccessType(element);
        return accessType == null ? this.propertyAccessType : accessType;
    }

    public AccessType getExplicitAccessType(XAnnotatedElement element) {
        Access access;
        AccessType accessType = null;
        if (element != null && (access = (Access)element.getAnnotation(Access.class)) != null) {
            accessType = AccessType.getAccessStrategy(access.value());
        }
        return accessType;
    }

    public void bindFiltersInHierarchy() {
        AnnotatedClassType classType;
        this.bindFilters((XAnnotatedElement)this.annotatedClass);
        for (XClass classToProcess = this.annotatedClass.getSuperclass(); classToProcess != null && (classType = this.context.getMetadataCollector().getClassType(classToProcess)) == AnnotatedClassType.MAPPED_SUPERCLASS; classToProcess = classToProcess.getSuperclass()) {
            this.bindFilters((XAnnotatedElement)classToProcess);
        }
    }

    private void bindFilters(XAnnotatedElement element) {
        Filter filter;
        Filters filters = BinderHelper.getOverridableAnnotation(element, Filters.class, this.context);
        if (filters != null) {
            for (Filter filter2 : filters.value()) {
                this.addFilter(filter2);
            }
        }
        if ((filter = (Filter)element.getAnnotation(Filter.class)) != null) {
            this.addFilter(filter);
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements NamingStrategyHelper {
        private final String className;
        private final String entityName;
        private final String jpaEntityName;

        private EntityTableNamingStrategyHelper(String className, String entityName, String jpaEntityName) {
            this.className = className;
            this.entityName = entityName;
            this.jpaEntityName = jpaEntityName;
        }

        @Override
        public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(new ImplicitEntityNameSource(){
                private final EntityNaming entityNaming = new EntityNaming(){

                    @Override
                    public String getClassName() {
                        return className;
                    }

                    @Override
                    public String getEntityName() {
                        return entityName;
                    }

                    @Override
                    public String getJpaEntityName() {
                        return jpaEntityName;
                    }
                };

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return buildingContext;
                }
            });
        }

        @Override
        public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
            return EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext).getIdentifierHelper().toIdentifier(explicitName);
        }

        @Override
        public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext));
        }

        private static JdbcEnvironment jdbcEnvironment(MetadataBuildingContext buildingContext) {
            return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
        }
    }

    private static class LocalCacheAnnotationStub
    implements Cache {
        private final String region;
        private final CacheConcurrencyStrategy usage;

        private LocalCacheAnnotationStub(String region, CacheConcurrencyStrategy usage) {
            this.region = region;
            this.usage = usage;
        }

        @Override
        public CacheConcurrencyStrategy usage() {
            return this.usage;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public boolean includeLazy() {
            return true;
        }

        @Override
        public String include() {
            return "all";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Cache.class;
        }
    }
}

