/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class PathFilter {
    protected final Set<String> paths;

    static PathFilter unconstrained() {
        return Unconstrained.INSTANCE;
    }

    static PathFilter of(Set<String> includedPaths, Set<String> excludedPaths) {
        if (includedPaths == null || includedPaths.isEmpty()) {
            if (excludedPaths != null && !excludedPaths.isEmpty()) {
                return new ExcludePathFilter(excludedPaths);
            }
            return PathFilter.unconstrained();
        }
        HashSet<String> actualIncludedPaths = new HashSet<String>();
        for (String path : includedPaths) {
            actualIncludedPaths.add(path);
            PathFilter.addSubPathsFromRoot(actualIncludedPaths, path);
        }
        return new IncludePathFilter(actualIncludedPaths);
    }

    private PathFilter(Set<String> paths) {
        this.paths = paths;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[paths=" + String.valueOf(this.paths) + "]";
    }

    abstract boolean isExplicitlyIncluded(String var1);

    abstract boolean isExplicitlyExcluded(String var1);

    abstract boolean isPotentiallyExcluded(String var1);

    abstract boolean isAnyPathExplicitlyIncluded();

    private static void addSubPathsFromRoot(Set<String> collector, String path) {
        int afterPreviousDotIndex = 0;
        int nextDotIndex = path.indexOf(46, afterPreviousDotIndex);
        while (nextDotIndex >= 0) {
            String subPath = path.substring(0, nextDotIndex);
            collector.add(subPath);
            afterPreviousDotIndex = nextDotIndex + 1;
            nextDotIndex = path.indexOf(46, afterPreviousDotIndex);
        }
    }

    private static class Unconstrained
    extends PathFilter {
        private static final PathFilter INSTANCE = new Unconstrained();

        private Unconstrained() {
            super(Collections.emptySet());
        }

        @Override
        boolean isExplicitlyIncluded(String relativePath) {
            return false;
        }

        @Override
        boolean isExplicitlyExcluded(String relativePath) {
            return false;
        }

        @Override
        boolean isPotentiallyExcluded(String path) {
            return false;
        }

        @Override
        boolean isAnyPathExplicitlyIncluded() {
            return false;
        }
    }

    private static class ExcludePathFilter
    extends PathFilter {
        private ExcludePathFilter(Set<String> paths) {
            super(paths);
        }

        @Override
        boolean isExplicitlyIncluded(String relativePath) {
            return false;
        }

        @Override
        boolean isExplicitlyExcluded(String relativePath) {
            return this.paths.contains(relativePath);
        }

        @Override
        boolean isPotentiallyExcluded(String pathToTest) {
            for (String excludePath : this.paths) {
                if (!excludePath.equals(pathToTest) && (!excludePath.startsWith(pathToTest) || !excludePath.startsWith(".", pathToTest.length()))) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean isAnyPathExplicitlyIncluded() {
            return false;
        }
    }

    private static class IncludePathFilter
    extends PathFilter {
        private IncludePathFilter(Set<String> paths) {
            super(paths);
        }

        @Override
        boolean isExplicitlyIncluded(String relativePath) {
            return this.paths.contains(relativePath);
        }

        @Override
        boolean isExplicitlyExcluded(String relativePath) {
            return false;
        }

        @Override
        boolean isPotentiallyExcluded(String path) {
            return false;
        }

        @Override
        boolean isAnyPathExplicitlyIncluded() {
            return true;
        }
    }
}

