/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.logging.Logger;

public abstract class CachedPreparedStatement
extends JBossWrapper
implements PreparedStatement {
    private static final long serialVersionUID = 2085461257386274373L;
    protected static Logger log = Logger.getLogger(CachedPreparedStatement.class);
    private PreparedStatement ps;
    private AtomicBoolean cached = new AtomicBoolean(true);
    private AtomicInteger inUse = new AtomicInteger(1);
    private int defaultMaxFieldSize;
    private int defaultMaxRows;
    private int defaultQueryTimeout;
    private int defaultFetchDirection;
    private int defaultFetchSize;
    private int currentMaxFieldSize;
    private int currentMaxRows;
    private int currentQueryTimeout;
    private int currentFetchDirection;
    private int currentFetchSize;

    public CachedPreparedStatement(PreparedStatement ps) throws SQLException {
        this.ps = ps;
        this.defaultMaxFieldSize = ps.getMaxFieldSize();
        this.defaultMaxRows = ps.getMaxRows();
        this.defaultQueryTimeout = ps.getQueryTimeout();
        this.defaultFetchDirection = ps.getFetchDirection();
        this.defaultFetchSize = ps.getFetchSize();
        this.currentMaxFieldSize = this.defaultMaxFieldSize;
        this.currentMaxRows = this.defaultMaxRows;
        this.currentQueryTimeout = this.defaultQueryTimeout;
        this.currentFetchDirection = this.defaultFetchDirection;
        this.currentFetchSize = this.defaultFetchSize;
    }

    public PreparedStatement getUnderlyingPreparedStatement() {
        return this.ps;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    public boolean isInUse() {
        return this.inUse.get() > 0;
    }

    public void inUse() {
        this.inUse.incrementAndGet();
    }

    private void closePreparedStatement() throws SQLException {
        if (log.isTraceEnabled()) {
            Throwable t = new Throwable("PreparedStatement.close() called");
            t.setStackTrace(SecurityActions.getStackTrace(Thread.currentThread()));
            log.trace((Object)t.getMessage(), t);
        }
        this.ps.close();
    }

    public void agedOut() throws SQLException {
        this.cached.set(false);
        if (this.inUse.get() == 0) {
            this.closePreparedStatement();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.inUse.decrementAndGet() == 0) {
            if (!this.cached.get()) {
                this.closePreparedStatement();
            } else {
                if (this.defaultMaxFieldSize != this.currentMaxFieldSize) {
                    this.ps.setMaxFieldSize(this.defaultMaxFieldSize);
                    this.currentMaxFieldSize = this.defaultMaxFieldSize;
                }
                if (this.defaultMaxRows != this.currentMaxRows) {
                    this.ps.setMaxRows(this.defaultMaxRows);
                    this.currentMaxRows = this.defaultMaxRows;
                }
                if (this.defaultQueryTimeout != this.currentQueryTimeout) {
                    this.ps.setQueryTimeout(this.defaultQueryTimeout);
                    this.currentQueryTimeout = this.defaultQueryTimeout;
                }
                if (this.defaultFetchDirection != this.currentFetchDirection) {
                    this.ps.setFetchDirection(this.defaultFetchDirection);
                    this.currentFetchDirection = this.defaultFetchDirection;
                }
                if (this.defaultFetchSize != this.currentFetchSize) {
                    this.ps.setFetchSize(this.defaultFetchSize);
                    this.currentFetchSize = this.defaultFetchSize;
                }
                this.ps.clearParameters();
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
        this.currentMaxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
        this.currentMaxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
        this.currentQueryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
        this.currentFetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
        this.currentFetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ps.setNString(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps.setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ps.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ps.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ps.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ps.isCloseOnCompletion();
    }

    @Override
    protected PreparedStatement getWrappedObject() throws SQLException {
        return this.ps;
    }
}

