/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.soteria.mechanisms.openid.domain.AccessTokenImpl;
import org.glassfish.soteria.mechanisms.openid.domain.IdentityTokenImpl;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.wildfly.security.soteria.original.OpenIdContextImpl;
import org.wildfly.security.soteria.original.OpenIdCredential;
import org.wildfly.security.soteria.original.TokenController;

@ApplicationScoped
public class OpenIdIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(OpenIdIdentityStore.class.getName());
    @Inject
    private OpenIdContextImpl context;
    @Inject
    private TokenController tokenController;
    @Inject
    private OpenIdConfiguration configuration;

    public CredentialValidationResult validate(OpenIdCredential credential) {
        HttpMessageContext httpContext = credential.getHttpContext();
        IdentityTokenImpl idToken = credential.getIdentityTokenImpl();
        Algorithm idTokenAlgorithm = idToken.getTokenJWT().getHeader().getAlgorithm();
        JWTClaimsSet idTokenClaims = Objects.isNull(this.context.getIdentityToken()) ? this.tokenController.validateIdToken(idToken, httpContext) : this.tokenController.validateRefreshedIdToken(this.context.getIdentityToken(), idToken);
        this.context.setIdentityToken(idToken.withClaims(idTokenClaims));
        AccessTokenImpl accessToken = (AccessTokenImpl)credential.getAccessToken();
        if (Objects.nonNull(accessToken)) {
            this.tokenController.validateAccessToken(accessToken, idTokenAlgorithm, this.context.getIdentityToken().getClaims());
            this.context.setAccessToken((AccessToken)accessToken);
        }
        String callerName = this.getCallerName();
        Set<String> callerGroups = this.getCallerGroups();
        LOGGER.log(Level.FINER, () -> "Returning caller name: " + callerName);
        LOGGER.log(Level.FINE, () -> "Returning caller: " + callerGroups);
        return new CredentialValidationResult(callerName, callerGroups);
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof OpenIdCredential) {
            return this.validate((OpenIdCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    private String getCallerName() {
        String callerNameClaim = this.configuration.getClaimsConfiguration().getCallerNameClaim();
        String callerName = this.context.getIdentityToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
        if (callerName == null) {
            callerName = this.context.getAccessToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (callerName == null) {
            callerName = this.context.getClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (callerName == null) {
            callerName = this.context.getSubject();
        }
        return callerName;
    }

    private Set<String> getCallerGroups() {
        String callerGroupsClaim = this.configuration.getClaimsConfiguration().getCallerGroupsClaim();
        List groupsAccessClaim = this.context.getAccessToken().getJwtClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsAccessClaim.isEmpty()) {
            return new HashSet<String>(groupsAccessClaim);
        }
        List groupsIdentityClaim = this.context.getIdentityToken().getJwtClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsIdentityClaim.isEmpty()) {
            return new HashSet<String>(groupsIdentityClaim);
        }
        List groupsUserinfoClaim = this.context.getClaims().getArrayStringClaim(callerGroupsClaim);
        if (!groupsUserinfoClaim.isEmpty()) {
            return new HashSet<String>(groupsUserinfoClaim);
        }
        return Collections.emptySet();
    }
}

