/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.IndexEntry;

@ProtoTypeId(value=4203)
public class IndexStatisticsSnapshotImpl
implements IndexStatisticsSnapshot {
    private final Map<String, IndexInfo> indexInfos;
    private final boolean reindexing;

    public IndexStatisticsSnapshotImpl() {
        this(new HashMap<String, IndexInfo>(), false);
    }

    public IndexStatisticsSnapshotImpl(Map<String, IndexInfo> indexInfos, boolean reindexing) {
        this.indexInfos = indexInfos;
        this.reindexing = reindexing;
    }

    @ProtoFactory
    public IndexStatisticsSnapshotImpl(List<IndexEntry> entries, boolean reindexing) {
        this.indexInfos = IndexStatisticsSnapshotImpl.toMap(entries);
        this.reindexing = reindexing;
    }

    @Override
    public Map<String, IndexInfo> indexInfos() {
        return this.indexInfos;
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    public List<IndexEntry> getEntries() {
        return IndexStatisticsSnapshotImpl.fromMap(this.indexInfos);
    }

    static Map<String, IndexInfo> toMap(List<IndexEntry> entries) {
        return Collections.unmodifiableMap(entries.stream().collect(Collectors.toMap(IndexEntry::getName, IndexEntry::getIndexInfo)));
    }

    static List<IndexEntry> fromMap(Map<String, IndexInfo> map) {
        return map.entrySet().stream().map(e -> new IndexEntry((String)e.getKey(), (IndexInfo)e.getValue())).collect(Collectors.toList());
    }

    @Override
    @ProtoField(number=2, defaultValue="false")
    public boolean reindexing() {
        return this.reindexing;
    }

    public Json toJson() {
        return Json.object().set("types", Json.make(this.indexInfos)).set("reindexing", Json.make((Object)this.reindexing));
    }

    @Override
    public IndexStatisticsSnapshot merge(IndexStatisticsSnapshot other) {
        other.indexInfos().forEach((k, v) -> this.indexInfos.merge((String)k, (IndexInfo)v, IndexInfo::merge));
        return this;
    }
}

