/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.servlet.util.SavedRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;
import org.wildfly.elytron.web.undertow.server.servlet.ServletSecurityContextImpl;
import org.wildfly.security.cache.CachedIdentity;

public class SessionManagerFactoryConfigurationAdapter<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
extends WebDeploymentConfigurationAdapter
implements org.wildfly.clustering.session.SessionManagerFactoryConfiguration<Map<String, Object>> {
    private final OptionalInt maxActiveSessions;
    private final ByteBufferMarshaller marshaller;
    private final Immutability immutability;
    private final SessionAttributePersistenceStrategy attributePersistenceStrategy;

    public SessionManagerFactoryConfigurationAdapter(SessionManagerFactoryConfiguration configuration, C managementConfiguration, Immutability immutability) {
        super((WebDeploymentConfiguration)configuration);
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        DeploymentUnit unit = configuration.getDeploymentUnit();
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        this.marshaller = (ByteBufferMarshaller)managementConfiguration.getMarshallerFactory().apply(configuration.getDeploymentUnit());
        LinkedList<Immutability> loadedImmutabilities = new LinkedList<Immutability>();
        for (Immutability loadedImmutability : module.loadService(Immutability.class)) {
            loadedImmutabilities.add(loadedImmutability);
        }
        this.immutability = Immutability.composite(List.of(Immutability.getDefault(), Immutability.classes(List.of(AuthenticatedSessionManager.AuthenticatedSession.class, SavedRequest.class, CachedIdentity.class, ServletSecurityContextImpl.IdentityContainer.class)), Immutability.composite(loadedImmutabilities), immutability));
        this.attributePersistenceStrategy = managementConfiguration.getAttributePersistenceStrategy();
    }

    public OptionalInt getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.marshaller;
    }

    public Supplier<Map<String, Object>> getSessionContextFactory() {
        return ConcurrentHashMap::new;
    }

    public Immutability getImmutability() {
        return this.immutability;
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.attributePersistenceStrategy;
    }
}

