/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ChildResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;

public class SubsystemResourceDescriptionResolver
extends StandardResourceDescriptionResolver
implements ParentResourceDescriptionResolver {
    private static final String DEFAULT_RESOURCE_NAME = "LocalDescriptions";
    private final String bundleName;
    private final WeakReference<ClassLoader> bundleLoader;

    public SubsystemResourceDescriptionResolver(String subsystemName, Class<?> targetClass) {
        this(subsystemName, targetClass, DEFAULT_RESOURCE_NAME);
    }

    public SubsystemResourceDescriptionResolver(String subsystemName, Class<?> targetClass, String resourceName) {
        this(subsystemName, String.join((CharSequence)".", targetClass.getPackage().getName(), resourceName), targetClass.getClassLoader());
    }

    private SubsystemResourceDescriptionResolver(String prefix, String bundleName, ClassLoader bundleLoader) {
        super(prefix, bundleName, bundleLoader, true, false);
        this.bundleName = bundleName;
        this.bundleLoader = new WeakReference<ClassLoader>(bundleLoader);
    }

    @Override
    public ParentResourceDescriptionResolver createChildResolver(PathElement path, List<PathElement> alternatePaths) {
        List<ResourceDescriptionResolver> alternates = alternatePaths.isEmpty() ? List.of() : alternatePaths.stream().map(this::createResolver).collect(Collectors.toUnmodifiableList());
        return new ChildResourceDescriptionResolver(this, this.createResolver(path), alternates);
    }

    private ParentResourceDescriptionResolver createResolver(PathElement path) {
        List<String> keys = path.isWildcard() ? List.of(this.getKeyPrefix(), path.getKey()) : List.of(this.getKeyPrefix(), path.getKey(), path.getValue());
        return new SubsystemResourceDescriptionResolver(String.join((CharSequence)".", keys), this.bundleName, (ClassLoader)this.bundleLoader.get());
    }
}

