/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.util.EnumSet;
import org.wildfly.common.Assert;

public enum SupportLevel {
    UNSUPPORTED,
    POSSIBLY_SUPPORTED,
    SUPPORTED;

    private static final int fullSize;

    public boolean isDefinitelySupported() {
        return this == SUPPORTED;
    }

    public boolean mayBeSupported() {
        return this != UNSUPPORTED;
    }

    public boolean isNotSupported() {
        return this == UNSUPPORTED;
    }

    public static boolean isFull(EnumSet<SupportLevel> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(SupportLevel v1) {
        return this == v1;
    }

    public boolean in(SupportLevel v1, SupportLevel v2) {
        return this == v1 || this == v2;
    }

    public boolean in(SupportLevel v1, SupportLevel v2, SupportLevel v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(SupportLevel ... values) {
        if (values != null) {
            for (SupportLevel value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    public static SupportLevel max(SupportLevel o1, SupportLevel o2) {
        Assert.checkNotNullParam("o1", o1);
        Assert.checkNotNullParam("o2", o2);
        return o1.compareTo(o2) < 0 ? o2 : o1;
    }

    static {
        fullSize = SupportLevel.values().length;
    }
}

