/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.micrometer.MicrometerDependencyProcessor;
import org.wildfly.extension.micrometer.MicrometerDeploymentProcessor;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.jmx.JmxMicrometerCollector;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.registry.NoOpRegistry;
import org.wildfly.extension.micrometer.registry.WildFlyOtlpRegistry;
import org.wildfly.extension.micrometer.registry.WildFlyRegistry;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

class MicrometerSubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    private static final String MICROMETER_MODULE = "org.wildfly.extension.micrometer";
    private static final String MICROMETER_API_MODULE = "org.wildfly.micrometer.deployment";
    static final PathElement PATH = SubsystemResourceDefinitionRegistrar.pathElement((String)"micrometer");
    public static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("micrometer", MicrometerSubsystemRegistrar.class);
    static final RuntimeCapability<Void> MICROMETER_COLLECTOR_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.micrometer.wildfly-collector", MicrometerCollector.class).addRequirements(new NullaryServiceDescriptor[]{ModelControllerClientFactory.SERVICE_DESCRIPTOR, Capabilities.MANAGEMENT_EXECUTOR, ProcessStateNotifier.SERVICE_DESCRIPTOR}).build();
    static final String[] EXPORTED_MODULES = new String[]{"org.wildfly.micrometer.deployment", "io.opentelemetry.otlp", "io.micrometer"};
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING).setAttributeGroup("otlp-registry")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STEP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"step", (ModelType)ModelType.LONG, (boolean)true).setAttributeGroup("otlp-registry")).setDefaultValue(new ModelNode(TimeUnit.MINUTES.toSeconds(1L)))).setMeasurementUnit(MeasurementUnit.SECONDS)).setAllowExpression(true)).setRestartAllServices()).build();
    static final StringListAttributeDefinition EXPOSED_SUBSYSTEMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("exposed-subsystems").setDefaultValue(ModelNode.fromJSONString((String)"[\"*\"]"))).setRequired(false)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{EXPOSED_SUBSYSTEMS, ENDPOINT, STEP};
    private final AtomicReference<MicrometerDeploymentConfiguration> deploymentConfig = new AtomicReference();

    MicrometerSubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)PATH), (ResourceDescriptionResolver)RESOLVER).build());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).addCapability(MICROMETER_COLLECTOR_RUNTIME_CAPABILITY)).addAttributes(List.of(ENDPOINT, STEP, EXPOSED_SUBSYSTEMS))).withDeploymentChainContributor(target -> {
            target.addDeploymentProcessor("micrometer", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new MicrometerDependencyProcessor());
            target.addDeploymentProcessor("micrometer", Phase.POST_MODULE, 14166, (DeploymentUnitProcessor)new MicrometerDeploymentProcessor(this.deploymentConfig.get()));
        })).withAddOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).withRemoveOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final List exposedSubsystems = EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model);
        final boolean exposeAnySubsystem = exposedSubsystems.remove("*");
        String endpoint = ENDPOINT.resolveModelAttribute(context, model).asStringOrNull();
        Long step = STEP.resolveModelAttribute(context, model).asLong();
        final WildFlyRegistry wildFlyRegistry = endpoint != null ? new WildFlyOtlpRegistry(new WildFlyMicrometerConfig(endpoint, step)) : new NoOpRegistry();
        try {
            new JmxMicrometerCollector(wildFlyRegistry).init();
        }
        catch (IOException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.failedInitializeJMXRegistrar(e);
        }
        ServiceDependency mccf = ServiceDependency.on((NullaryServiceDescriptor)ModelControllerClientFactory.SERVICE_DESCRIPTOR);
        ServiceDependency executor = ServiceDependency.on((NullaryServiceDescriptor)Capabilities.MANAGEMENT_EXECUTOR);
        ServiceDependency processStateNotifier = ServiceDependency.on((NullaryServiceDescriptor)ProcessStateNotifier.SERVICE_DESCRIPTOR);
        Supplier<MicrometerCollector> collectorSupplier = () -> new MicrometerCollector(((ModelControllerClientFactory)mccf.get()).createClient((Executor)executor.get()), (ProcessStateNotifier)processStateNotifier.get(), wildFlyRegistry);
        this.deploymentConfig.set(new MicrometerDeploymentConfiguration(){

            @Override
            public WildFlyRegistry getRegistry() {
                return wildFlyRegistry;
            }

            @Override
            public Predicate<String> getSubsystemFilter() {
                return subsystem -> exposeAnySubsystem || exposedSubsystems.contains(subsystem);
            }
        });
        AtomicReference captor = new AtomicReference();
        context.addStep((operationContext, modelNode) -> {
            MicrometerCollector collector = (MicrometerCollector)captor.get();
            if (collector != null) {
                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                collector.collectResourceMetrics(rootResource, rootResourceRegistration, Function.identity(), this.deploymentConfig.get().getSubsystemFilter());
            }
        }, OperationContext.Stage.VERIFY);
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(MICROMETER_COLLECTOR_RUNTIME_CAPABILITY, collectorSupplier).requires(List.of(mccf, executor, processStateNotifier))).withCaptor(captor::set)).asActive()).build();
    }

    public static interface MicrometerDeploymentConfiguration {
        public WildFlyRegistry getRegistry();

        public Predicate<String> getSubsystemFilter();
    }
}

