/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.remote.configuration.Attribute;

public class TrustStoreConfiguration {
    static final AttributeDefinition<String> TRUSTSTORE_FILENAME = AttributeDefinition.builder((Enum)Attribute.FILENAME, null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> TRUSTSTORE_TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, (Object)"JKS", String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> TRUSTSTORE_PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, String.class).serializer(AttributeSerializer.SECRET).immutable().autoPersist(false).build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TrustStoreConfiguration.class, new AttributeDefinition[]{TRUSTSTORE_FILENAME, TRUSTSTORE_TYPE, TRUSTSTORE_PASSWORD});
    }

    TrustStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String trustStoreFileName() {
        return (String)this.attributes.attribute(TRUSTSTORE_FILENAME).get();
    }

    public String trustStoreType() {
        return (String)this.attributes.attribute(TRUSTSTORE_TYPE).get();
    }

    public char[] trustStorePassword() {
        return Util.toCharArray((String)((String)this.attributes.attribute(TRUSTSTORE_PASSWORD).get()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustStoreConfiguration that = (TrustStoreConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

