/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public interface MapEntry<K, V>
extends Map.Entry<K, V> {
    public <KK, VV> MapEntry<KK, VV> map(Function<K, KK> var1, Function<V, VV> var2);

    @Override
    default public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public static <K, V> MapEntry<K, V> of(final K key, final V value) {
        return new MapEntry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public <KK, VV> MapEntry<KK, VV> map(Function<K, KK> keyMapper, Function<V, VV> valueMapper) {
                return MapEntry.of(keyMapper.apply(key), valueMapper.apply(value));
            }

            @Override
            public int hashCode() {
                return key != null ? key.hashCode() : 0;
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Objects.equals(key, entry.getKey()) && Objects.equals(value, entry.getValue());
            }

            public String toString() {
                return key + "=" + value;
            }
        };
    }
}

