/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.process.protocol.StreamUtils;
import org.jboss.as.process.stdin.Base64InputStream;
import org.jboss.as.server.DomainServerCommunicationServices;
import org.jboss.as.server.ServerTask;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.as.server.operations.ServerDomainProcessShutdownHandler;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class DomainServerMain {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static volatile AuthenticationContext latestAuthenticationContext;

    private DomainServerMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AsyncFuture<ServiceContainer> containerFuture;
        Base64InputStream initialInput = new Base64InputStream(System.in);
        PrintStream initialError = System.err;
        try {
            Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        STDOUT.println("--Installing Stdio Context--");
        STDOUT.flush();
        STDERR.println("--Installing Stdio Context--");
        STDERR.flush();
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        byte[] asAuthBytes = new byte[24];
        try {
            StreamUtils.readFully((InputStream)initialInput, (byte[])asAuthBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            SystemExiter.abort(1);
            throw new IllegalStateException();
        }
        MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)DomainServerMain.class.getClassLoader());
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setVersion(2);
            configuration.setClassResolver((ClassResolver)new SimpleClassResolver(DomainServerMain.class.getClassLoader()));
            Unmarshaller unmarshaller = factory.createUnmarshaller(configuration);
            ByteInput byteInput = Marshalling.createByteInput((InputStream)initialInput);
            unmarshaller.start(byteInput);
            ServerTask task = (ServerTask)unmarshaller.readObject(ServerTask.class);
            unmarshaller.finish();
            containerFuture = task.run(Arrays.asList(new ServiceActivator(){

                public void activate(ServiceActivatorContext serviceActivatorContext) {
                }
            }));
        }
        catch (Throwable t) {
            t.printStackTrace(initialError);
            SystemExiter.abort(1);
            throw new IllegalStateException();
        }
        Throwable caught = null;
        while (true) {
            try {
                while (true) {
                    AuthenticationContext replacementAuthenticationContext;
                    String scheme = StreamUtils.readUTFZBytes((InputStream)initialInput);
                    String hostName = StreamUtils.readUTFZBytes((InputStream)initialInput);
                    int port = StreamUtils.readInt((InputStream)initialInput);
                    boolean managementSubsystemEndpoint = StreamUtils.readBoolean((InputStream)initialInput);
                    String serverAuthToken = StreamUtils.readUTFZBytes((InputStream)initialInput);
                    URI hostControllerUri = new URI(scheme, null, NetworkUtils.formatPossibleIpv6Address((String)hostName), port, null, null, null);
                    ServiceContainer container = (ServiceContainer)containerFuture.get();
                    if (container.isShutdown()) continue;
                    HostControllerClient client = DomainServerMain.getRequiredService(container, HostControllerConnectionService.SERVICE_NAME, HostControllerClient.class);
                    latestAuthenticationContext = replacementAuthenticationContext = DomainServerCommunicationServices.createAuthenticationContext(client.getServerName(), serverAuthToken);
                    client.reconnect(hostControllerUri, replacementAuthenticationContext, managementSubsystemEndpoint);
                }
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                continue;
            }
            catch (EOFException e) {
            }
            catch (Throwable t) {
                t.printStackTrace();
                caught = t;
            }
            break;
        }
        CompletionStage<Void> suspendStage = ServerDomainProcessShutdownHandler.SUSPEND_STAGE.get();
        try {
            if (suspendStage != null) {
                suspendStage.toCompletableFuture().join();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (caught == null) {
                SystemExiter.logAndExit(ServerLogger.ROOT_LOGGER::shuttingDownInResponseToProcessControllerSignal, 0);
            } else {
                SystemExiter.abort(1);
            }
        }
    }

    static AuthenticationContext getLatestAuthenticationContext() {
        return latestAuthenticationContext;
    }

    static <T> T getRequiredService(ServiceContainer container, ServiceName serviceName, Class<T> type) {
        ServiceController controller = container.getRequiredService(serviceName);
        return type.cast(controller.getValue());
    }
}

