/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.suspend;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.wildfly.common.Assert;
import org.wildfly.common.function.Functions;

public class SuspendController
implements ServerSuspendController,
SuspendableActivityRegistry {
    private static final Supplier<List<SuspendableActivity>> FACTORY = CopyOnWriteArrayList::new;
    private final List<List<SuspendableActivity>> activityGroups = Stream.generate(FACTORY).limit(SuspendableActivityRegistry.SuspendPriority.LAST.ordinal() + 1).collect(Collectors.toUnmodifiableList());
    private final Map<SuspendableActivity, SuspendableActivityRegistry.SuspendPriority> priorities = Collections.synchronizedMap(new IdentityHashMap());
    private final List<OperationListener> listeners = new CopyOnWriteArrayList<OperationListener>();
    private volatile SuspensionStateProvider.State state = SuspensionStateProvider.State.SUSPENDED;

    @Override
    public void reset() {
        this.state = SuspensionStateProvider.State.SUSPENDED;
    }

    @Override
    public CompletionStage<Void> suspend(ServerSuspendContext context) {
        if (this.state == SuspensionStateProvider.State.SUSPENDED) {
            return SuspendableActivity.COMPLETED;
        }
        this.state = SuspensionStateProvider.State.PRE_SUSPEND;
        for (OperationListener listener : this.listeners) {
            listener.suspendStarted();
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.phaseStage(this.activityGroups, SuspendableActivity::prepare, context, Functions.discardingBiConsumer()).whenComplete((ignored, prepareException) -> {
            if (prepareException != null) {
                result.completeExceptionally((Throwable)prepareException);
            } else {
                this.state = SuspensionStateProvider.State.SUSPENDING;
                this.phaseStage(this.activityGroups, SuspendableActivity::suspend, context, Functions.discardingBiConsumer()).whenComplete((ignore, suspendException) -> {
                    if (suspendException != null) {
                        result.completeExceptionally((Throwable)suspendException);
                    } else {
                        this.state = SuspensionStateProvider.State.SUSPENDED;
                        result.complete(null);
                        for (OperationListener listener : this.listeners) {
                            listener.complete();
                        }
                    }
                });
            }
        });
        return result;
    }

    @Override
    public CompletionStage<Void> resume(ServerResumeContext context) {
        if (this.state == SuspensionStateProvider.State.RUNNING) {
            return SuspendableActivity.COMPLETED;
        }
        CompletionStage<Void> resumeStage = this.phaseStage(this::resumeIterator, SuspendableActivity::resume, context, ServerLogger.ROOT_LOGGER::failedToResume);
        resumeStage.whenComplete((ignore, exception) -> {
            if (exception == null) {
                this.state = SuspensionStateProvider.State.RUNNING;
                for (OperationListener listener : this.listeners) {
                    listener.cancelled();
                }
            }
        });
        return resumeStage;
    }

    private Iterator<List<SuspendableActivity>> resumeIterator() {
        return SuspendController.reverseIterator(this.activityGroups);
    }

    private <C> CompletionStage<Void> phaseStage(Iterable<List<SuspendableActivity>> activityGroups, BiFunction<SuspendableActivity, C, CompletionStage<Void>> phase, C context, final BiConsumer<SuspendableActivity, Throwable> exceptionHandler) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        final AtomicInteger counter = new AtomicInteger(this.activityGroups.size());
        BiConsumer<Void, Throwable> groupCompleter = new BiConsumer<Void, Throwable>(){

            @Override
            public void accept(Void ignore, Throwable exception) {
                if (exception != null) {
                    result.completeExceptionally(exception);
                } else if (counter.decrementAndGet() == 0) {
                    result.complete(null);
                }
            }
        };
        for (List<SuspendableActivity> group : activityGroups) {
            List<SuspendableActivity> activities = List.copyOf(group);
            if (activities.isEmpty()) {
                groupCompleter.accept(null, null);
                continue;
            }
            final CompletableFuture groupStage = new CompletableFuture();
            groupStage.whenComplete(groupCompleter);
            final AtomicInteger groupCounter = new AtomicInteger(activities.size());
            for (final SuspendableActivity activity : activities) {
                BiConsumer<Void, Throwable> activityCompleter = new BiConsumer<Void, Throwable>(){

                    @Override
                    public void accept(Void ignore, Throwable exception) {
                        if (exception != null) {
                            try {
                                exceptionHandler.accept(activity, exception);
                            }
                            finally {
                                groupStage.completeExceptionally(exception);
                            }
                        } else if (groupCounter.decrementAndGet() == 0) {
                            groupStage.complete(null);
                        }
                    }
                };
                try {
                    phase.apply(activity, context).whenComplete(activityCompleter);
                }
                catch (Throwable e) {
                    activityCompleter.accept(null, e);
                }
            }
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public void nonGracefulStart() {
        this.resume(ServerSuspendController.Context.STARTUP).toCompletableFuture().join();
    }

    @Deprecated(forRemoval=true)
    public void resume() {
        this.resume(ServerSuspendController.Context.RUNNING).toCompletableFuture().join();
    }

    @Deprecated(forRemoval=true)
    public void suspend(long timeoutMillis) {
        ServerLogger.ROOT_LOGGER.suspendingServer(timeoutMillis, TimeUnit.MILLISECONDS);
        CompletableFuture<Void> suspend = this.suspend(ServerSuspendController.Context.RUNNING).toCompletableFuture();
        if (timeoutMillis >= 0L) {
            suspend.completeOnTimeout(null, timeoutMillis, TimeUnit.MILLISECONDS);
        }
        suspend.join();
    }

    private static <E> Iterator<E> reverseIterator(List<E> list) {
        final ListIterator<E> iterator = list.listIterator(list.size());
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasPrevious();
            }

            @Override
            public E next() {
                return iterator.previous();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }
        };
    }

    @Override
    public void registerActivity(SuspendableActivity activity, SuspendableActivityRegistry.SuspendPriority priority) {
        Assert.checkNotNullParam((String)"activity", (Object)activity);
        Assert.checkNotNullParam((String)"priority", (Object)priority);
        if (priority.ordinal() < SuspendableActivityRegistry.SuspendPriority.FIRST.ordinal() || priority.ordinal() > SuspendableActivityRegistry.SuspendPriority.LAST.ordinal()) {
            throw new IllegalArgumentException(String.valueOf(priority.ordinal()));
        }
        if (this.priorities.putIfAbsent(activity, priority) == null) {
            this.activityGroups.get(priority.ordinal()).add(activity);
            if (this.state != SuspensionStateProvider.State.RUNNING) {
                activity.suspend(ServerSuspendController.Context.STARTUP).toCompletableFuture().join();
            }
        }
    }

    @Override
    public void unregisterActivity(SuspendableActivity activity) {
        SuspendableActivityRegistry.SuspendPriority priority = this.priorities.remove(activity);
        if (priority != null) {
            this.activityGroups.get(priority.ordinal()).remove(activity);
        }
    }

    @Override
    public SuspensionStateProvider.State getState() {
        return this.state;
    }

    @Override
    public void addListener(OperationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OperationListener listener) {
        this.listeners.remove(listener);
    }

    @Deprecated(forRemoval=true)
    public void setStartSuspended(boolean startSuspended) {
        this.reset();
    }

    @Deprecated(forRemoval=true)
    public void registerActivity(ServerActivity activity) {
        this.registerActivity(activity, SuspendableActivityRegistry.SuspendPriority.of(activity.getExecutionGroup()));
    }

    @Deprecated(forRemoval=true)
    public void unRegisterActivity(ServerActivity activity) {
        this.unregisterActivity(activity);
    }
}

