/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.common.function.Functions;

public class DefaultSessionCreationMetaDataEntry<C>
implements SessionCreationMetaDataEntry<C> {
    private final Instant creationTime;
    private volatile Duration timeout = Duration.ZERO;
    private final Supplied<C> context = Supplied.cached();

    public DefaultSessionCreationMetaDataEntry() {
        this(Instant.now().truncatedTo(ChronoUnit.MILLIS));
    }

    public DefaultSessionCreationMetaDataEntry(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public Supplied<C> getContext() {
        return this.context;
    }

    public SessionCreationMetaDataEntry<C> remap(Supplier<Offset<Duration>> timeoutOffset) {
        DefaultSessionCreationMetaDataEntry<C> result = new DefaultSessionCreationMetaDataEntry<C>(this.creationTime);
        result.setTimeout((Duration)timeoutOffset.get().apply((Object)this.timeout));
        result.getContext().get(Functions.constantSupplier((Object)this.context.get(Functions.constantSupplier(null))));
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(" { ");
        builder.append("created = ").append(this.creationTime);
        builder.append(", timeout = ").append(this.timeout);
        return builder.append(" }").toString();
    }
}

