/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.config.ServerConfigFactoryImpl;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.deployers.TCCLDeploymentProcessor;
import org.jboss.as.webservices.deployers.deployment.WSDeploymentBuilder;
import org.jboss.as.webservices.util.WSAttachmentKeys;

public final class WSModelDeploymentProcessor
extends TCCLDeploymentProcessor
implements DeploymentUnitProcessor {
    @Override
    public void internalDeploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        WSDeploymentBuilder.getInstance().build(unit);
        if (WSModelDeploymentProcessor.isWebServiceDeployment(unit)) {
            ServerConfigImpl config = (ServerConfigImpl)ServerConfigFactoryImpl.getConfig();
            config.incrementWSDeploymentCount();
        }
    }

    @Override
    public void internalUndeploy(DeploymentUnit context) {
        if (WSModelDeploymentProcessor.isWebServiceDeployment(context)) {
            ServerConfigImpl config = (ServerConfigImpl)ServerConfigFactoryImpl.getConfig();
            config.decrementWSDeploymentCount();
        }
        context.removeAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
    }

    private static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY) != null;
    }
}

