/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpServerExchange;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;

final class HttpNamingServerObjectResolver
implements ObjectResolver {
    private static final String PATH_DELIMITERS = "/\\";
    private URIAffinity selfNodeAffinity;

    public HttpNamingServerObjectResolver(HttpServerExchange exchange) {
        try {
            this.selfNodeAffinity = this.createLocalURIAffinity(exchange);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private URIAffinity createLocalURIAffinity(HttpServerExchange exchange) throws URISyntaxException {
        String requestPath = exchange.getRequestPath();
        StringTokenizer st = new StringTokenizer(requestPath, PATH_DELIMITERS);
        String connectorPath = st.nextToken();
        StringBuilder uriStringBuilder = new StringBuilder();
        uriStringBuilder.append(exchange.getRequestScheme()).append("://").append(exchange.getHostAndPort()).append("/").append(connectorPath);
        return new URIAffinity(new URI(uriStringBuilder.toString()));
    }

    public Object readResolve(Object replacement) {
        return replacement;
    }

    public Object writeReplace(Object original) {
        if (original == Affinity.LOCAL && this.selfNodeAffinity != null) {
            return this.selfNodeAffinity;
        }
        return original;
    }
}

