/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.features.throttling;

import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingManager;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;

public class EndpointMetricsThrottlingManager
extends ThrottleResponse
implements ThrottlingManager {
    private long faultPermit = Integer.MAX_VALUE;
    private long requestPermit = Integer.MAX_VALUE;
    private long averageProcessingTimePermit = Long.MAX_VALUE;
    private long maxProcessingTimePermit = Long.MAX_VALUE;
    private long minProcessingTimePermit = Long.MAX_VALUE;
    private long totalProcessingTimePermit = Long.MAX_VALUE;
    private int responseStatusCode = 429;
    private long delayTime = 0L;
    private String message = "";

    public List<String> getDecisionPhases() {
        return Collections.singletonList("pre-stream");
    }

    public ThrottleResponse getThrottleResponse(String phase, Message m) {
        Endpoint endpoint = (Endpoint)m.getExchange().get(Endpoint.class);
        if (endpoint != null && EndpointMetricsThrottlingManager.getServerConfig().isStatisticsEnabled() && (endpoint.getEndpointMetrics().getFaultCount() > this.getFaultPermit() || endpoint.getEndpointMetrics().getRequestCount() > this.getRequestPermit() || endpoint.getEndpointMetrics().getMaxProcessingTime() > this.getMaxProcessingTimePermit() || endpoint.getEndpointMetrics().getMinProcessingTime() > this.getMinProcessingTimePermit() || endpoint.getEndpointMetrics().getAverageProcessingTime() > this.getAverageProcessingTimePermit() || endpoint.getEndpointMetrics().getTotalProcessingTime() > this.getTotalProcessingTimePermit())) {
            if (!this.getMessage().isEmpty()) {
                this.setResponseCode(this.getResponseStatusCode(), this.getMessage());
            } else {
                this.setResponseCode(this.getResponseStatusCode());
            }
            if (this.getDelayTime() > 0L) {
                this.setDelay(this.getDelayTime());
            }
            return this;
        }
        return null;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(int responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getFaultPermit() {
        return this.faultPermit;
    }

    public void setFaultPermit(long faultPermit) {
        this.faultPermit = faultPermit;
    }

    public long getRequestPermit() {
        return this.requestPermit;
    }

    public void setRequestPermit(long requestPermit) {
        this.requestPermit = requestPermit;
    }

    public long getMaxProcessingTimePermit() {
        return this.maxProcessingTimePermit;
    }

    public void setMaxProcessingTimePermit(long maxProcessingTimePermit) {
        this.maxProcessingTimePermit = maxProcessingTimePermit;
    }

    public long getMinProcessingTimePermit() {
        return this.minProcessingTimePermit;
    }

    public void setMinProcessingTimePermit(long minProcessingTimePermit) {
        this.minProcessingTimePermit = minProcessingTimePermit;
    }

    public long getTotalProcessingTimePermit() {
        return this.totalProcessingTimePermit;
    }

    public void setTotalProcessingTimePermit(long totalProcessingTimePermit) {
        this.totalProcessingTimePermit = totalProcessingTimePermit;
    }

    public long getAverageProcessingTimePermit() {
        return this.averageProcessingTimePermit;
    }

    public void setAverageProcessingTimePermit(long averageProcessingTimePermit) {
        this.averageProcessingTimePermit = averageProcessingTimePermit;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    private static ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }
}

