/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastGroupRemove;
import org.wildfly.extension.messaging.activemq.SocketBroadcastGroupRemove;

public class BroadcastGroupRemove
extends AbstractRemoveStepHandler {
    public static final BroadcastGroupRemove INSTANCE = new BroadcastGroupRemove(false);
    public static final BroadcastGroupRemove LEGACY_INSTANCE = new BroadcastGroupRemove(true);
    private final boolean isLegacyCall;

    private BroadcastGroupRemove(boolean isLegacyCall) {
        this.isLegacyCall = isLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.isLegacyCall) {
            ReloadRequiredRemoveStepHandler removeHandler;
            ModelNode op = operation.clone();
            PathAddress target = context.getCurrentAddress().getParent();
            try {
                context.readResourceFromRoot(target.append("jgroups-broadcast-group", context.getCurrentAddressValue()), false);
                target = target.append("jgroups-broadcast-group", context.getCurrentAddressValue());
                removeHandler = JGroupsBroadcastGroupRemove.LEGACY_INSTANCE;
            }
            catch (Resource.NoSuchResourceException ex) {
                target = target.append("socket-broadcast-group", context.getCurrentAddressValue());
                removeHandler = SocketBroadcastGroupRemove.LEGACY_INSTANCE;
            }
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)removeHandler, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

