/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import jakarta.transaction.TransactionManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.transaction.client.ContextTransactionManager;

class JMSBridgeService
implements Service<JMSBridge> {
    private final JMSBridge bridge;
    private final String bridgeName;
    private final String moduleName;
    private final Supplier<ExecutorService> executorSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> sourceCredentialSourceSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> targetCredentialSourceSupplier;

    public JMSBridgeService(String moduleName, String bridgeName, JMSBridge bridge, Supplier<ExecutorService> executorSupplier, ExceptionSupplier<CredentialSource, Exception> sourceCredentialSourceSupplier, ExceptionSupplier<CredentialSource, Exception> targetCredentialSourceSupplier) {
        if (bridge == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("bridge");
        }
        this.moduleName = moduleName;
        this.bridgeName = bridgeName;
        this.bridge = bridge;
        this.executorSupplier = executorSupplier;
        this.sourceCredentialSourceSupplier = sourceCredentialSourceSupplier;
        this.targetCredentialSourceSupplier = targetCredentialSourceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.setTransactionManager((TransactionManager)ContextTransactionManager.getInstance());
                    JMSBridgeService.this.startBridge();
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "JMS Bridge"));
                }
            }
        };
        try {
            this.executorSupplier.get().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void startBridge() throws Exception {
        Module module = this.moduleName != null ? Module.getContextModuleLoader().loadModule(ModuleIdentifierUtil.canonicalModuleIdentifier((String)this.moduleName)) : Module.forClass(JMSBridgeService.class);
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.setJMSBridgePasswordsFromCredentialSource();
            this.bridge.start();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
        MessagingLogger.ROOT_LOGGER.startedService("JMS Bridge", this.bridgeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.stop();
                    MessagingLogger.ROOT_LOGGER.stoppedService("JMS Bridge", JMSBridgeService.this.bridgeName);
                    context.complete();
                }
                catch (Exception e) {
                    MessagingLogger.ROOT_LOGGER.failedToDestroy("JMS Bridge", JMSBridgeService.this.bridgeName);
                }
            }
        };
        try {
            this.executorSupplier.get().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public JMSBridge getValue() throws IllegalStateException {
        return this.bridge;
    }

    private void setJMSBridgePasswordsFromCredentialSource() {
        this.setNewJMSBridgePassword(this.sourceCredentialSourceSupplier, arg_0 -> ((JMSBridge)this.bridge).setSourcePassword(arg_0));
        this.setNewJMSBridgePassword(this.targetCredentialSourceSupplier, arg_0 -> ((JMSBridge)this.bridge).setTargetPassword(arg_0));
    }

    private void setNewJMSBridgePassword(ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier, Consumer<String> passwordConsumer) {
        if (credentialSourceSupplier != null) {
            try {
                char[] password;
                CredentialSource credentialSource = (CredentialSource)credentialSourceSupplier.get();
                if (credentialSource != null && (password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword()) != null) {
                    passwordConsumer.accept(new String(password));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

