/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpLargeMessageTest
extends AmqpClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Random rand = new Random(System.currentTimeMillis());
    @Parameter(index=0)
    public int frameSize = Short.MAX_VALUE;
    @Parameter(index=1)
    public int payload = 112640;
    @Parameter(index=2)
    public int amqpMinLargeMessageSize = 102400;
    @Parameter(index=3)
    public boolean jdbc = false;
    String testQueueName = "ConnectionFrameSize";

    @Parameters(name="frameSize={0}, payload={1}, amqpMinLargeMessageSize={2}, jdbc={3}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Short.MAX_VALUE, 112640, 102400, false}, {204800, 0x113000, 450560, false}, {10240, 102400, 20480, true});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setJournalFileSize(0x500000);
        if (this.jdbc) {
            this.setDBStoreType(server.getConfiguration());
        }
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("maxFrameSize", this.frameSize);
        params.put("amqpMinLargeMessageSize", this.amqpMinLargeMessageSize);
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("tcp", "tcp://localhost:61616");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveCore() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), this.testQueueName);
            Assertions.assertEquals((int)nMsgs, (int)count);
            org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            this.receiveJMS(nMsgs, (ConnectionFactory)factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSendAndGetData() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int nMsgs = 1;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), this.testQueueName);
            Assertions.assertEquals((int)nMsgs, (int)count);
            Queue serverQueue = this.server.locateQueue(this.testQueueName);
            serverQueue.forEach(ref -> {
                try {
                    AMQPLargeMessage message = (AMQPLargeMessage)ref.getMessage();
                    Assertions.assertFalse((boolean)message.hasScheduledDeliveryTime());
                    ReadableBuffer dataBuffer = message.getData();
                    try (LargeBodyReader reader = message.getLargeBodyReader();){
                        Assertions.assertEquals((long)reader.getSize(), (long)dataBuffer.remaining());
                        reader.open();
                        ByteBuffer buffer = ByteBuffer.allocate(dataBuffer.remaining());
                        reader.readInto(buffer);
                        ByteUtil.equals((byte[])buffer.array(), (byte[])dataBuffer.array());
                    }
                }
                catch (AssertionError assertionError) {
                    throw assertionError;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPMessageWithComplexAnnotationsReceiveCore() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            connection.connect();
            String annotation = "x-opt-embedded-map";
            LinkedHashMap<String, String> embeddedMap = new LinkedHashMap<String, String>();
            embeddedMap.put("test-key-1", "value-1");
            embeddedMap.put("test-key-2", "value-2");
            embeddedMap.put("test-key-3", "value-3");
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.testQueueName);
            AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
            message.setApplicationProperty("IntProperty", 42);
            message.setDurable(true);
            message.setMessageAnnotation(annotation, embeddedMap);
            sender.send(message);
            session.close();
            Wait.assertEquals((int)1, () -> this.getMessageCount(this.server.getPostOffice(), this.testQueueName));
            try (org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
                 Connection connection2 = factory.createConnection();){
                Session session2 = connection2.createSession(false, 1);
                connection2.start();
                MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(this.testQueueName));
                Message received = consumer.receive(5000L);
                Assertions.assertNotNull((Object)received);
                Assertions.assertEquals((int)42, (int)received.getIntProperty("IntProperty"));
                connection2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveOpenWire() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), this.testQueueName);
            Assertions.assertEquals((int)nMsgs, (int)count);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
            this.receiveJMS(nMsgs, (ConnectionFactory)factory);
        }
    }

    private void sendMessages(int nMsgs, AmqpConnection connection) throws Exception {
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.testQueueName);
        for (int i = 0; i < nMsgs; ++i) {
            AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
            message.setApplicationProperty("i", i);
            message.setDurable(true);
            sender.send(message);
        }
        session.close();
    }

    private void receiveJMS(int nMsgs, ConnectionFactory factory) throws JMSException {
        Connection connection2 = factory.createConnection();
        Session session2 = connection2.createSession(false, 1);
        connection2.start();
        MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(this.testQueueName));
        for (int i = 0; i < nMsgs; ++i) {
            Message message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
        }
        connection2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveAMQP() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            this.sendMessages(nMsgs, connection);
            int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
            Assertions.assertEquals((int)nMsgs, (int)count);
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(nMsgs);
            for (int i = 0; i < nMsgs; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)message, (String)("failed at " + i));
                MessageImpl wrapped = (MessageImpl)message.getWrappedMessage();
                if (wrapped.getBody() instanceof Data) {
                    Data data = (Data)wrapped.getBody();
                    logger.debug("received : message: {}", (Object)data.getValue().getLength());
                    Assertions.assertEquals((int)this.payload, (int)data.getValue().getLength());
                }
                message.accept();
            }
            session.close();
        }
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPMessageWithComplexAnnotationsReceiveAMQP() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 200;
        AmqpClient client = this.createAmqpClient();
        Symbol annotation = Symbol.valueOf((String)"x-opt-embedded-map");
        LinkedHashMap<String, String> embeddedMap = new LinkedHashMap<String, String>();
        embeddedMap.put("test-key-1", "value-1");
        embeddedMap.put("test-key-2", "value-2");
        embeddedMap.put("test-key-3", "value-3");
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(testQueueName);
        AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
        message.setApplicationProperty("IntProperty", 42);
        message.setDurable(true);
        message.setMessageAnnotation(annotation.toString(), embeddedMap);
        sender.send(message);
        session.close();
        connection.close();
        Wait.assertEquals((int)1, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName));
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(testQueueName);
        receiver.flow(nMsgs);
        message = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"Failed to read message with embedded map in annotations");
        MessageImpl wrapped = (MessageImpl)message.getWrappedMessage();
        if (wrapped.getBody() instanceof Data) {
            Data data = (Data)wrapped.getBody();
            logger.debug("received : message: {}", (Object)data.getValue().getLength());
            Assertions.assertEquals((int)this.payload, (int)data.getValue().getLength());
        }
        Assertions.assertNotNull((Object)message.getWrappedMessage().getMessageAnnotations());
        Assertions.assertNotNull((Object)message.getWrappedMessage().getMessageAnnotations().getValue());
        Assertions.assertEquals(embeddedMap, message.getWrappedMessage().getMessageAnnotations().getValue().get(annotation));
        message.accept();
        session.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testHugeString() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        StringBuilder unicodeStringBuilder = new StringBuilder();
        for (char c = '\u03e8'; c < '\u2af8'; c = (char)(c + '\u0001')) {
            unicodeStringBuilder.append(c);
        }
        String unicodeString = unicodeStringBuilder.toString();
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 0x100000) {
            builder.append("hello " + unicodeString);
        }
        producer.send((Message)session.createTextMessage(builder.toString()));
        session.commit();
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage message = (TextMessage)consumer.receive(50000L);
        Assertions.assertNotNull((Object)message);
        session.commit();
        Assertions.assertEquals((Object)builder.toString(), (Object)message.getText());
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveAMQPViaJMSObjectMessage() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendObjectMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        Assertions.assertEquals((int)nMsgs, (int)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveAMQPViaJMSText() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendTextMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        Assertions.assertEquals((int)nMsgs, (int)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendAMQPReceiveAMQPViaJMSBytes() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        String testQueueName = "ConnectionFrameSize";
        int nMsgs = 1;
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        this.sendBytesMessages(nMsgs, (ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"));
        int count = this.getMessageCount(this.server.getPostOffice(), testQueueName);
        Assertions.assertEquals((int)nMsgs, (int)count);
        this.receiveJMS(nMsgs, (ConnectionFactory)factory);
    }

    private byte[] createLargePayload(int sizeInBytes) {
        byte[] payload = new byte[sizeInBytes];
        for (int i = 0; i < sizeInBytes; ++i) {
            payload[i] = (byte)this.rand.nextInt(256);
        }
        logger.debug("Created buffer with size : {} bytes", (Object)sizeInBytes);
        return payload;
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendHugeHeader() throws Exception {
        Assumptions.assumeFalse((boolean)this.jdbc);
        this.doTestSendHugeHeader(this.payload);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendLargeMessageWithHugeHeader() throws Exception {
        Assumptions.assumeFalse((boolean)this.jdbc);
        this.doTestSendHugeHeader(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSendHugeHeader(int expectedSize) throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            connection.connect();
            int strLength = 524288;
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.testQueueName);
            AmqpMessage message = this.createAmqpMessage((byte)65, expectedSize);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 524288; ++i) {
                buffer.append(" ");
            }
            message.setApplicationProperty("str", buffer.toString());
            message.setDurable(true);
            try {
                sender.send(message);
                Assertions.fail();
            }
            catch (IOException e) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof JMSException));
                Assertions.assertTrue((boolean)e.getMessage().contains("AMQ149005"));
            }
            session.close();
        }
    }

    @TestTemplate
    public void testLargeHeaderTXLargeBody() throws Exception {
        Assumptions.assumeFalse((boolean)this.jdbc);
        this.testLargeHeaderTX(true);
    }

    @TestTemplate
    public void testLargeHeaderTXSmallBody() throws Exception {
        Assumptions.assumeFalse((boolean)this.jdbc);
        this.testLargeHeaderTX(false);
    }

    private void testLargeHeaderTX(boolean largeBody) throws Exception {
        TextMessage message;
        MessageProducer producer;
        Session session;
        String testQueueName = RandomUtil.randomString();
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST));
        ConnectionFactory cf = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < 0x100000) {
            buffer.append("This is a large string ");
        }
        String largeString = buffer.toString();
        String smallString = "small string";
        String body = largeBody ? largeString : smallString;
        try (Connection connection = cf.createConnection();){
            session = connection.createSession(true, 0);
            producer = session.createProducer((Destination)session.createQueue(testQueueName));
            producer.setDeliveryMode(2);
            message = session.createTextMessage(body);
            message.setStringProperty("test", largeString);
            boolean failed = false;
            try {
                producer.send((Message)message);
                session.commit();
            }
            catch (Exception expected) {
                failed = true;
            }
            Assertions.assertTrue((boolean)failed);
        }
        connection = cf.createConnection();
        try {
            session = connection.createSession(true, 0);
            producer = session.createProducer((Destination)session.createQueue(testQueueName));
            message = session.createTextMessage(body);
            message.setStringProperty("test", smallString);
            producer.send((Message)message);
            session.commit();
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(testQueueName));
            TextMessage recMessage = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)smallString, (Object)recMessage.getStringProperty("test"));
            Assertions.assertEquals((Object)body, (Object)recMessage.getText());
            session.commit();
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Queue serverQueue = this.server.locateQueue(testQueueName);
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount());
        File largeMessageFolder = this.server.getConfiguration().getLargeMessagesLocation();
        File[] files = largeMessageFolder.listFiles();
        Assertions.assertTrue((files == null || files.length == 0 ? 1 : 0) != 0, (String)(files == null ? "Null Files" : "There are " + files.length + " files in the large message folder"));
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendSmallerMessages() throws Exception {
        for (int i = 512; i <= 8192; i += 512) {
            this.doTestSendLargeMessage(i);
        }
    }

    @TestTemplate
    @Timeout(value=120L)
    public void testSendFixedSizedMessages() throws Exception {
        this.doTestSendLargeMessage(65536);
        this.doTestSendLargeMessage(131072);
        this.doTestSendLargeMessage(262144);
    }

    @TestTemplate
    @Timeout(value=120L)
    public void testSend1MBMessage() throws Exception {
        this.doTestSendLargeMessage(0x100000);
    }

    @Disabled(value="Useful for performance testing")
    @TestTemplate
    @Timeout(value=120L)
    public void testSend10MBMessage() throws Exception {
        this.doTestSendLargeMessage(0xA00000);
    }

    @Disabled(value="Useful for performance testing")
    @TestTemplate
    @Timeout(value=120L)
    public void testSend100MBMessage() throws Exception {
        this.doTestSendLargeMessage(0x6400000);
    }

    public void doTestSendLargeMessage(int expectedSize) throws Exception {
        logger.debug("doTestSendLargeMessage called with expectedSize {}", (Object)expectedSize);
        byte[] payload = this.createLargePayload(expectedSize);
        Assertions.assertEquals((int)expectedSize, (int)payload.length);
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            long startTime = System.currentTimeMillis();
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.name);
            MessageProducer producer = session.createProducer((Destination)queue);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(payload);
            producer.setDeliveryMode(1);
            producer.setPriority(4);
            producer.send((Message)message);
            long endTime = System.currentTimeMillis();
            logger.debug("Returned from send after {} ms", (Object)(endTime - startTime));
            startTime = System.currentTimeMillis();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            logger.debug("Calling receive");
            Message received = consumer.receive();
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof BytesMessage));
            BytesMessage bytesMessage = (BytesMessage)received;
            Assertions.assertNotNull((Object)bytesMessage);
            endTime = System.currentTimeMillis();
            logger.debug("Returned from receive after {} ms", (Object)(endTime - startTime));
            byte[] bytesReceived = new byte[expectedSize];
            Assertions.assertEquals((int)expectedSize, (int)bytesMessage.readBytes(bytesReceived, expectedSize));
            Assertions.assertTrue((boolean)Arrays.equals(payload, bytesReceived));
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testReceiveRedeliveredLargeMessagesWithSessionFlowControl() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int numMsgs = 10;
        int msgSize = 2000000;
        int maxFrameSize = this.frameSize;
        int sessionCapacity = 2500000;
        byte[] payload = this.createLargePayload(msgSize);
        Assertions.assertEquals((int)msgSize, (int)payload.length);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.setSessionIncomingCapacity(sessionCapacity);
        connection.connect();
        this.addConnection(connection);
        try {
            int i;
            String testQueueName = this.getTestName();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(testQueueName);
            for (int i2 = 0; i2 < numMsgs; ++i2) {
                AmqpMessage message = new AmqpMessage();
                message.setBytes(payload);
                sender.send(message);
            }
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueName), (long)5000L, (long)10L);
            AmqpReceiver receiver = session.createReceiver(testQueueName);
            receiver.flow(numMsgs);
            ArrayList<AmqpMessage> messages = new ArrayList<AmqpMessage>();
            for (i = 0; i < numMsgs; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)message, (String)("failed at " + i));
                messages.add(message);
            }
            for (i = 0; i < numMsgs; ++i) {
                AmqpMessage msg = (AmqpMessage)messages.get(i);
                msg.modified(true, false);
            }
            receiver.close();
            AmqpReceiver receiver2 = session.createReceiver(testQueueName);
            receiver2.flow(numMsgs);
            for (int i3 = 0; i3 < numMsgs; ++i3) {
                AmqpMessage message = receiver2.receive(5L, TimeUnit.SECONDS);
                this.validateMessage(payload, i3, message);
                message.accept();
            }
            session.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testReceiveLargeMessagesMultiplexedOnSameSession() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        int numMsgs = 10;
        int maxFrameSize = this.frameSize;
        int msgSizeA = this.frameSize * 4;
        int msgSizeB = maxFrameSize / 2;
        int sessionCapacity = msgSizeA + maxFrameSize;
        byte[] payloadA = this.createLargePayload(msgSizeA);
        Assertions.assertEquals((int)msgSizeA, (int)payloadA.length);
        byte[] payloadB = this.createLargePayload(msgSizeB);
        Assertions.assertEquals((int)msgSizeB, (int)payloadB.length);
        String testQueueNameA = this.getTestName() + "A";
        String testQueueNameB = this.getTestName() + "B";
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = client.createConnection();
        connection.setMaxFrameSize(maxFrameSize);
        connection.setSessionIncomingCapacity(sessionCapacity);
        connection.connect();
        this.addConnection(connection);
        try {
            AmqpSession session = connection.createSession();
            AmqpSender senderA = session.createSender(testQueueNameA);
            AmqpSender senderB = session.createSender(testQueueNameB);
            for (int i = 0; i < numMsgs; ++i) {
                AmqpMessage messageA = new AmqpMessage();
                messageA.setBytes(payloadA);
                senderA.send(messageA);
                AmqpMessage messageB = new AmqpMessage();
                messageB.setBytes(payloadB);
                senderB.send(messageB);
            }
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueNameA), (long)5000L, (long)10L);
            Wait.assertEquals((int)numMsgs, () -> this.getMessageCount(this.server.getPostOffice(), testQueueNameB), (long)5000L, (long)10L);
            AmqpReceiver receiverA = session.createReceiver(testQueueNameA);
            AmqpReceiver receiverB = session.createReceiver(testQueueNameB);
            receiverA.flow(numMsgs / 2, true);
            receiverB.flow(numMsgs / 2);
            receiverA.flow(numMsgs / 2, true);
            receiverB.flow(numMsgs / 2);
            ArrayList<AmqpMessage> messagesA = new ArrayList<AmqpMessage>();
            ArrayList<AmqpMessage> messagesB = new ArrayList<AmqpMessage>();
            long timeout = 6000L;
            long start = System.nanoTime();
            boolean timeRemaining = true;
            while (timeRemaining) {
                if (messagesA.size() < numMsgs) {
                    logger.debug("Attempting to receive message for receiver A");
                    AmqpMessage messageA = receiverA.receive(20L, TimeUnit.MILLISECONDS);
                    if (messageA != null) {
                        logger.debug("Got message for receiver A");
                        messagesA.add(messageA);
                        messageA.accept();
                    }
                }
                if (messagesB.size() < numMsgs) {
                    logger.debug("Attempting to receive message for receiver B");
                    AmqpMessage messageB = receiverB.receive(20L, TimeUnit.MILLISECONDS);
                    if (messageB != null) {
                        logger.debug("Got message for receiver B");
                        messagesB.add(messageB);
                        messageB.accept();
                    }
                }
                if (messagesA.size() == numMsgs && messagesB.size() == numMsgs) {
                    logger.debug("Received expected messages");
                    break;
                }
                timeRemaining = System.nanoTime() - start < TimeUnit.MILLISECONDS.toNanos(timeout);
            }
            Assertions.assertTrue((boolean)timeRemaining, (String)("Failed to receive all messages in expected time: A=" + messagesA.size() + ", B=" + messagesB.size()));
            Assertions.assertNull((Object)receiverA.receiveNoWait(), (String)"Unexpected additional message present for A");
            Assertions.assertNull((Object)receiverB.receiveNoWait(), (String)"Unexpected additional message present for B");
            for (int i = 0; i < numMsgs; ++i) {
                AmqpMessage messageA = (AmqpMessage)messagesA.get(i);
                this.validateMessage(payloadA, i, messageA);
                AmqpMessage messageB = (AmqpMessage)messagesB.get(i);
                this.validateMessage(payloadB, i, messageB);
            }
            receiverA.close();
            receiverB.close();
            session.close();
        }
        finally {
            connection.close();
        }
    }

    private void validateMessage(byte[] expectedPayload, int msgNum, AmqpMessage message) {
        Assertions.assertNotNull((Object)message, (String)("failed at " + msgNum));
        Section body = message.getWrappedMessage().getBody();
        Assertions.assertNotNull((Object)body, (String)("No message body for msg " + msgNum));
        Assertions.assertTrue((boolean)(body instanceof Data), (String)("Unexpected message body type for msg " + body.getClass()));
        Assertions.assertEquals((Object)new Binary(expectedPayload, 0, expectedPayload.length), (Object)((Data)body).getValue(), (String)"Unexpected body content for msg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testMessageWithAmqpValueAndEmptyBinaryPreservesBody() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            message.getWrappedMessage().setBody((Section)new AmqpValue((Object)new Binary(new byte[0])));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"failed to read large AMQP message");
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            Assertions.assertTrue((boolean)(wrapped.getBody() instanceof AmqpValue));
            AmqpValue body = (AmqpValue)wrapped.getBody();
            Assertions.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = (Binary)body.getValue();
            Assertions.assertEquals((int)0, (int)payload.getLength());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testMessageWithDataAndEmptyBinaryPreservesBody() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            message.getWrappedMessage().setBody((Section)new Data(new Binary(new byte[0])));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"failed to read large AMQP message");
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            Assertions.assertTrue((boolean)(wrapped.getBody() instanceof Data));
            Data body = (Data)wrapped.getBody();
            Assertions.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = body.getValue();
            Assertions.assertEquals((int)0, (int)payload.getLength());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testMessageWithDataAndContentTypeOfTextPreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            String messageText = "This text will be in a Data Section";
            message.getWrappedMessage().setContentType("text/plain");
            message.getWrappedMessage().setBody((Section)new Data(new Binary(messageText.getBytes(StandardCharsets.UTF_8))));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"failed to read large AMQP message");
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            Assertions.assertTrue((boolean)(wrapped.getBody() instanceof Data));
            Data body = (Data)wrapped.getBody();
            Assertions.assertTrue((boolean)(body.getValue() instanceof Binary));
            Binary payload = body.getValue();
            String reconstitutedString = new String(payload.getArray(), payload.getArrayOffset(), payload.getLength(), StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)messageText, (Object)reconstitutedString);
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testMessageWithAmqpValueListPreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            ArrayList<String> values = new ArrayList<String>();
            values.add("1");
            values.add("2");
            values.add("3");
            message.getWrappedMessage().setBody((Section)new AmqpValue(values));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"failed to read large AMQP message");
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            Assertions.assertTrue((boolean)(wrapped.getBody() instanceof AmqpValue));
            AmqpValue body = (AmqpValue)wrapped.getBody();
            Assertions.assertTrue((boolean)(body.getValue() instanceof List));
            List payload = (List)body.getValue();
            Assertions.assertEquals((int)3, (int)payload.size());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testMessageWithAmqpSequencePreservesBodyType() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            ArrayList<String> values = new ArrayList<String>();
            values.add("1");
            values.add("2");
            values.add("3");
            message.getWrappedMessage().setBody((Section)new AmqpSequence(values));
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"failed to read large AMQP message");
            MessageImpl wrapped = (MessageImpl)received.getWrappedMessage();
            Assertions.assertTrue((boolean)(wrapped.getBody() instanceof AmqpSequence));
            AmqpSequence body = (AmqpSequence)wrapped.getBody();
            Assertions.assertTrue((boolean)(body.getValue() instanceof List));
            List payload = body.getValue();
            Assertions.assertEquals((int)3, (int)payload.size());
            received.accept();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testDeleteUnreferencedMessage() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            AmqpMessage message = this.createAmqpMessage((byte)65, this.payload);
            message.setDurable(true);
            sender.send(message);
            sender.close();
        }
        Queue queue = this.server.locateQueue(this.getTestName());
        queue.forEach(ref -> {
            if (ref.getMessage().isLargeMessage()) {
                try {
                    this.server.getStorageManager().storeAcknowledge(queue.getID().longValue(), ref.getMessageID());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.server.stop();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.server.start();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ221019"}));
        }
        this.validateNoFilesOnLargeDir();
        this.runAfter(() -> ((ActiveMQServer)this.server).stop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSimpleLargeMessageRestart() throws Exception {
        AmqpMessage message;
        AmqpSession session;
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDefaultAddressRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            session = connection.createSession();
            AmqpSender sender = session.createSender(this.getTestName());
            message = this.createAmqpMessage((byte)65, this.payload);
            message.setDurable(true);
            sender.send(message);
            sender.close();
        }
        this.server.stop();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.server.start();
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ221019"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ221018"}));
        }
        connection = this.addConnection(client.connect());
        try {
            session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getTestName());
            receiver.flow(1);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            message.accept();
            receiver.close();
            session.close();
        }
        finally {
            connection.close();
        }
        this.validateNoFilesOnLargeDir();
        this.runAfter(() -> ((ActiveMQServer)this.server).stop());
    }

    private void sendObjectMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            jakarta.jms.Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            ObjectMessage msg = session.createObjectMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.setObject((Serializable)((Object)builder.toString()));
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private void sendTextMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            jakarta.jms.Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage msg = session.createTextMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.setText(builder.toString());
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private void sendBytesMessages(int nMsgs, ConnectionFactory factory) throws Exception {
        try (Connection connection = factory.createConnection();){
            int i;
            Session session = connection.createSession();
            jakarta.jms.Queue queue = session.createQueue(this.testQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            BytesMessage msg = session.createBytesMessage();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.payload; ++i) {
                builder.append("A");
            }
            msg.writeBytes(builder.toString().getBytes(StandardCharsets.UTF_8));
            for (i = 0; i < nMsgs; ++i) {
                msg.setIntProperty("i", Integer.valueOf(i).intValue());
                producer.send((Message)msg);
            }
        }
    }

    private AmqpMessage createAmqpMessage(byte value, int payloadSize) {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[payloadSize];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = value;
        }
        message.setBytes(payload);
        return message;
    }

    private AmqpMessage createAmqpLargeMessageWithNoBody() {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[524288];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 65;
        }
        message.setMessageAnnotation("x-opt-big-blob", new String(payload, StandardCharsets.UTF_8));
        return message;
    }
}

