/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AmqpReferenceDeliveryAnnotationTest
extends AmqpClientTestSupport {
    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
    }

    @Test
    public void testReceiveAnnotations() throws Exception {
        this.internalReceiveAnnotations(false, false);
    }

    @Test
    public void testReceiveAnnotationsLargeMessage() throws Exception {
        this.internalReceiveAnnotations(true, false);
    }

    @Test
    public void testReceiveAnnotationsReboot() throws Exception {
        this.internalReceiveAnnotations(false, true);
    }

    @Test
    public void testReceiveAnnotationsLargeMessageReboot() throws Exception {
        this.internalReceiveAnnotations(true, true);
    }

    public void internalReceiveAnnotations(boolean largeMessage, boolean reboot) throws Exception {
        String body;
        final String uuid = RandomUtil.randomString();
        this.server.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerMessagePlugin(){

            public void beforeDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
                HashMap<Symbol, String> symbolObjectMap = new HashMap<Symbol, String>();
                DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(symbolObjectMap);
                symbolObjectMap.put(Symbol.getSymbol((String)"KEY"), uuid);
                reference.setProtocolData(DeliveryAnnotations.class, (Object)deliveryAnnotations);
            }
        });
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        if (largeMessage) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 0x100000; ++i) {
                buffer.append("*");
            }
            body = buffer.toString();
        } else {
            body = "test-message";
        }
        message.setMessageId("msg1");
        message.setText(body);
        message.setDurable(true);
        sender.send(message);
        message = new AmqpMessage();
        message.setMessageId("msg2");
        message.setDurable(true);
        message.setText(body);
        sender.send(message);
        sender.close();
        if (reboot) {
            connection.close();
            this.server.stop();
            this.server.start();
            client = this.createAmqpClient();
            connection = this.addConnection(client.connect());
            session = connection.createSession();
        }
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message");
        Assertions.assertEquals((Object)"msg1", (Object)received.getMessageId());
        Assertions.assertEquals((Object)uuid, (Object)received.getDeliveryAnnotation("KEY"));
        received.accept();
        received = receiver.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message");
        Assertions.assertEquals((Object)"msg2", (Object)received.getMessageId());
        Assertions.assertEquals((Object)uuid, (Object)received.getDeliveryAnnotation("KEY"));
        received.accept();
        Assertions.assertNull((Object)receiver.receiveNoWait());
        receiver.close();
        connection.close();
    }
}

