/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSecurityTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MIN_LARGE_MESSAGE_SIZE = 16384;

    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpMinLargeMessageSize", 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSaslAuthWithInvalidCredentials() throws Exception {
        AmqpClient client = this.createAmqpClient(this.guestUser, this.fullUser);
        try (AmqpConnection connection = null;){
            connection = client.connect();
            Assertions.fail((String)"Should not authenticate when invalid credentials provided");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSaslAuthWithAuthzid() throws Exception {
        AmqpConnection connection = null;
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        client.setAuthzid(this.guestUser);
        try {
            connection = client.connect();
        }
        catch (Exception ex) {
            Assertions.fail((String)"Should authenticate even with authzid set");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSaslAuthWithoutAuthzid() throws Exception {
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        try (AmqpConnection connection = null;){
            connection = client.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendAndRejected() throws Exception {
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Sender sender) {
                ErrorCondition condition = sender.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Sender should have been opened with an error");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            try {
                session.createSender(this.getQueueName());
                Assertions.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                logger.debug("Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageFailsOnAnonymousRelayWhenNotAuthorizedToSendToAddress() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                DeliveryState state = delivery.getRemoteState();
                if (!delivery.remotelySettled()) {
                    this.markAsInvalid("delivery is not remotely settled");
                }
                if (state instanceof Rejected) {
                    Rejected rejected = (Rejected)state;
                    if (rejected.getError() == null || rejected.getError().getCondition() == null) {
                        this.markAsInvalid("Delivery should have been Rejected with an error condition");
                    } else {
                        ErrorCondition error = rejected.getError();
                        if (!error.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                            this.markAsInvalid("Should have been tagged with unauthorized access error");
                        }
                    }
                } else {
                    this.markAsInvalid("Delivery should have been Rejected");
                }
                latch.countDown();
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress(this.getQueueName());
            message.setMessageId("msg1");
            message.setText("Test-Message");
            try {
                sender.send(message);
                Assertions.fail((String)"Should not be able to send, message should be rejected");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                sender.close();
            }
            Assertions.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
            connection.getStateInspector().assertValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testReceiverNotAuthorized() throws Exception {
        AmqpClient client = this.createAmqpClient(this.noprivPass, this.noprivUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Receiver receiver) {
                ErrorCondition condition = receiver.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Receiver should have been opened with an error");
                }
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            try {
                session.createReceiver(this.getQueueName());
                Assertions.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                logger.debug("Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testConsumerNotAuthorizedToCreateQueues() throws Exception {
        AmqpClient client = this.createAmqpClient(this.noprivPass, this.noprivUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Sender sender) {
                ErrorCondition condition = sender.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Sender should have been opened with an error");
                }
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            try {
                session.createReceiver(this.getQueueName(this.getPrecreatedQueueSize() + 1));
                Assertions.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                logger.debug("Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testAnonymousRelayLargeMessageSendFailsWithNotAuthorizedCleansUpLargeMessageFile() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                DeliveryState state = delivery.getRemoteState();
                if (!delivery.remotelySettled()) {
                    this.markAsInvalid("delivery is not remotely settled");
                }
                if (state instanceof Rejected) {
                    Rejected rejected = (Rejected)state;
                    if (rejected.getError() == null || rejected.getError().getCondition() == null) {
                        this.markAsInvalid("Delivery should have been Rejected with an error condition");
                    } else {
                        ErrorCondition error = rejected.getError();
                        if (!error.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                            this.markAsInvalid("Should have been tagged with unauthorized access error");
                        }
                    }
                } else {
                    this.markAsInvalid("Delivery should have been Rejected");
                }
                latch.countDown();
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = this.createAmqpLargeMessageWithNoBody();
            message.setAddress(this.getQueueName());
            message.setMessageId("msg1");
            try {
                sender.send(message);
                Assertions.fail((String)"Should not be able to send, message should be rejected");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                sender.close();
            }
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            connection.getStateInspector().assertValid();
        }
        this.validateNoFilesOnLargeDir();
    }

    private AmqpMessage createAmqpLargeMessageWithNoBody() {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 65;
        }
        message.setMessageAnnotation("x-opt-big-blob", new String(payload, StandardCharsets.UTF_8));
        return message;
    }
}

