/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AmqpSenderRoutingTypeTest
extends JMSClientTestSupport {
    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        Configuration serverConfig = server.getConfiguration();
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressSettings();
        if (map.size() == 0) {
            AddressSettings as = new AddressSettings();
            as.setDefaultAddressRoutingType(RoutingType.ANYCAST);
            map.put("#", as);
        }
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMQPSenderHonourRoutingTypeOfExistingAddress() throws Exception {
        RoutingType routingType = ((AddressSettings)this.server.getConfiguration().getAddressSettings().get("#")).getDefaultAddressRoutingType();
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)routingType);
        try (ActiveMQConnection coreConnection = (ActiveMQConnection)this.createCoreConnection();
             ClientSession clientSession = coreConnection.getSessionFactory().createSession();){
            RoutingType addressRoutingType = RoutingType.MULTICAST;
            SimpleString address = SimpleString.of((String)("myTopic_" + UUID.randomUUID().toString()));
            clientSession.createAddress(address, addressRoutingType, false);
            ClientSession.AddressQuery addressQuery = clientSession.addressQuery(address);
            Assertions.assertTrue((boolean)addressQuery.isExists());
            Assertions.assertTrue((boolean)addressQuery.getQueueNames().isEmpty());
            AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address.toString());
            try {
                ClientSession.QueueQuery queueQuery = clientSession.queueQuery(address);
                Assertions.assertFalse((boolean)queueQuery.isExists());
                Assertions.assertEquals((Object)addressRoutingType, (Object)queueQuery.getRoutingType());
            }
            finally {
                sender.close();
                session.close();
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMQPSenderCreateQueueWithDefaultRoutingTypeIfAddressDoNotExist() throws Exception {
        RoutingType defaultRoutingType = ((AddressSettings)this.server.getConfiguration().getAddressSettings().get("#")).getDefaultAddressRoutingType();
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)defaultRoutingType);
        try (ActiveMQConnection coreConnection = (ActiveMQConnection)this.createCoreConnection();
             ClientSession clientSession = coreConnection.getSessionFactory().createSession();){
            SimpleString address = SimpleString.of((String)("myTopic_" + UUID.randomUUID().toString()));
            ClientSession.AddressQuery addressQuery = clientSession.addressQuery(address);
            Assertions.assertFalse((boolean)addressQuery.isExists());
            Assertions.assertTrue((boolean)addressQuery.getQueueNames().isEmpty());
            AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address.toString());
            try {
                addressQuery = clientSession.addressQuery(address);
                Assertions.assertTrue((boolean)addressQuery.isExists());
                MatcherAssert.assertThat((Object)addressQuery.getQueueNames(), (Matcher)CoreMatchers.hasItem((Object)address));
                ClientSession.QueueQuery queueQuery = clientSession.queueQuery(address);
                Assertions.assertTrue((boolean)queueQuery.isExists());
                Assertions.assertEquals((Object)defaultRoutingType, (Object)queueQuery.getRoutingType());
            }
            finally {
                sender.close();
                session.close();
                connection.close();
            }
        }
    }
}

