/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTempDestinationTest
extends AmqpClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicSenderToTopic() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicSenderToQueue() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicSender(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        Assertions.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        Assertions.assertTrue((boolean)remoteTarget.getDynamic());
        Assertions.assertTrue((boolean)remoteTarget.getDurable().equals((Object)TerminusDurability.NONE));
        Assertions.assertTrue((boolean)remoteTarget.getExpiryPolicy().equals((Object)TerminusExpiryPolicy.LINK_DETACH));
        Map dynamicNodeProperties = remoteTarget.getDynamicNodeProperties();
        Assertions.assertTrue((boolean)dynamicNodeProperties.containsKey(AmqpSupport.LIFETIME_POLICY));
        Assertions.assertEquals((Object)DeleteOnClose.getInstance(), dynamicNodeProperties.get(AmqpSupport.LIFETIME_POLICY));
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        Assertions.assertNotNull((Object)queueView);
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicSenderLifetimeBoundToLinkTopic() throws Exception {
        this.doTestDynamicSenderLifetimeBoundToLinkQueue(true);
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicSenderLifetimeBoundToLinkQueue() throws Exception {
        this.doTestDynamicSenderLifetimeBoundToLinkQueue(false);
    }

    protected void doTestDynamicSenderLifetimeBoundToLinkQueue(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        Assertions.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        Assertions.assertNotNull((Object)queueView);
        sender.close();
        queueView = this.getProxyToQueue(remoteTarget.getAddress());
        Assertions.assertNull((Object)queueView);
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicReceiverToTopic() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicReceiverToQueue() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicReceiver(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        Assertions.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        Assertions.assertTrue((boolean)remoteSource.getDynamic());
        Assertions.assertTrue((boolean)remoteSource.getDurable().equals((Object)TerminusDurability.NONE));
        Assertions.assertTrue((boolean)remoteSource.getExpiryPolicy().equals((Object)TerminusExpiryPolicy.LINK_DETACH));
        Map dynamicNodeProperties = remoteSource.getDynamicNodeProperties();
        Assertions.assertTrue((boolean)dynamicNodeProperties.containsKey(AmqpSupport.LIFETIME_POLICY));
        Assertions.assertEquals((Object)DeleteOnClose.getInstance(), dynamicNodeProperties.get(AmqpSupport.LIFETIME_POLICY));
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        Assertions.assertNotNull((Object)queueView);
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicReceiverLifetimeBoundToLinkTopic() throws Exception {
        this.doTestDynamicReceiverLifetimeBoundToLinkQueue(true);
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicReceiverLifetimeBoundToLinkQueue() throws Exception {
        this.doTestDynamicReceiverLifetimeBoundToLinkQueue(false);
    }

    protected void doTestDynamicReceiverLifetimeBoundToLinkQueue(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        Assertions.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        Assertions.assertNotNull((Object)queueView);
        receiver.close();
        queueView = this.getProxyToQueue(remoteSource.getAddress());
        Assertions.assertNull((Object)queueView);
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void TestCreateDynamicQueueSenderAndPublish() throws Exception {
        this.doTestCreateDynamicSenderAndPublish(false);
    }

    @Test
    @Timeout(value=60L)
    public void TestCreateDynamicTopicSenderAndPublish() throws Exception {
        this.doTestCreateDynamicSenderAndPublish(true);
    }

    protected void doTestCreateDynamicSenderAndPublish(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        Assertions.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        Assertions.assertNotNull((Object)queueView);
        String address = sender.getSender().getRemoteTarget().getAddress();
        logger.debug("New dynamic sender address -> {}", (Object)address);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-1");
        message.setText("Test-Message");
        AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1);
        sender.send(message);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read a message");
        received.accept();
        receiver.close();
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicReceiverToTopicAndSend() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test
    @Timeout(value=60L)
    public void testCreateDynamicReceiverToQueueAndSend() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicReceiverAndSend(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        Assertions.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        Assertions.assertNotNull((Object)queueView);
        String address = receiver.getReceiver().getRemoteSource().getAddress();
        logger.debug("New dynamic receiver address -> {}", (Object)address);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-1");
        message.setText("Test-Message");
        AmqpSender sender = session.createSender(address);
        sender.send(message);
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read a message");
        received.accept();
        sender.close();
        receiver.close();
        connection.close();
    }
}

