/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSQueueBrowserTest
extends JMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testBrowseAllInQueueZeroPrefetch() throws Exception {
        int count;
        int MSG_COUNT = 5;
        JmsConnection connection = (JmsConnection)this.createConnection();
        ((JmsDefaultPrefetchPolicy)connection.getPrefetchPolicy()).setAll(0);
        connection.start();
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        for (count = 0; count < 5 && enumeration.hasMoreElements(); ++count) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
        }
        logger.debug("Received all expected message, checking that hasMoreElements returns false");
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)5, (int)count);
    }

    @Test
    @Timeout(value=40L)
    public void testCreateQueueBrowser() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        session.createConsumer((Destination)queue).close();
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
    }

    @Test
    @Timeout(value=40L)
    public void testNoMessagesBrowserHasNoElements() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        session.createConsumer((Destination)queue).close();
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Enumeration enumeration = browser.getEnumeration();
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
    }

    @Test
    @Timeout(value=30L)
    public void testBroseOneInQueue() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("hello"));
        producer.close();
        QueueBrowser browser = session.createBrowser(queue);
        Enumeration enumeration = browser.getEnumeration();
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            Assertions.assertTrue((boolean)(m instanceof TextMessage));
            logger.debug("Browsed message {} from Queue {}", (Object)m, (Object)queue);
        }
        browser.close();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)(msg instanceof TextMessage));
    }

    @Test
    @Timeout(value=60L)
    public void testBrowseAllInQueue() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
            ++count;
            TimeUnit.MILLISECONDS.sleep(50L);
        }
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)5, (int)count);
    }

    @Test
    @Timeout(value=60L)
    public void testBrowseAllInQueuePrefetchOne() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
            ++count;
        }
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)5, (int)count);
    }

    @Test
    @Timeout(value=40L)
    public void testBrowseAllInQueueTxSession() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
            ++count;
        }
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)5, (int)count);
    }

    @Test
    @Timeout(value=40L)
    public void testQueueBrowserInTxSessionLeavesOtherWorkUnaffected() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 5, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        MessageProducer txProducer = session.createProducer((Destination)queue);
        for (int i = 0; i < 5; ++i) {
            txProducer.send(session.createMessage());
        }
        Assertions.assertEquals((long)5L, (long)queueView.getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
            ++count;
        }
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)5, (int)count);
        browser.close();
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        session.commit();
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testBrowseAllInQueueSmallPrefetch() throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        int MSG_COUNT = 30;
        Session session = connection.createSession(false, 1);
        Assertions.assertNotNull((Object)session);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        this.sendMessages(this.name, 30, false);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)30L, () -> ((Queue)queueView).getMessageCount());
        QueueBrowser browser = session.createBrowser(queue);
        Assertions.assertNotNull((Object)browser);
        Enumeration enumeration = browser.getEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Message msg = (Message)enumeration.nextElement();
            Assertions.assertNotNull((Object)msg);
            logger.debug("Recv: {}", (Object)msg);
            ++count;
        }
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
        Assertions.assertEquals((int)30, (int)count);
    }
}

