/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMXManagementTest
extends JMSClientTestSupport {
    @Test
    public void testListDeliveringMessages() throws Exception {
        SimpleString queue = SimpleString.of((String)this.getQueueName());
        Connection connection1 = this.createConnection();
        Connection connection2 = this.createConnection();
        Session prodSession = connection1.createSession(false, 1);
        Session consSession = connection2.createSession(true, 0);
        Queue jmsQueue = prodSession.createQueue(queue.toString());
        QueueControl queueControl = this.createManagementControl(queue, queue);
        MessageProducer producer = prodSession.createProducer((Destination)jmsQueue);
        int num = 20;
        for (int i = 0; i < 20; ++i) {
            TextMessage message = prodSession.createTextMessage("hello" + i);
            producer.send((Message)message);
        }
        connection2.start();
        MessageConsumer consumer = consSession.createConsumer((Destination)jmsQueue);
        for (int i = 0; i < 20; ++i) {
            TextMessage msgRec = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)msgRec);
            Assertions.assertEquals((Object)msgRec.getText(), (Object)("hello" + i));
        }
        Wait.assertEquals((int)20, () -> queueControl.getDeliveringCount());
        Map result = null;
        Map[] msgMaps = null;
        for (int i = 0; i < 10; ++i) {
            result = queueControl.listDeliveringMessages();
            Assertions.assertEquals((int)1, (int)result.size());
            msgMaps = (Map[])result.entrySet().iterator().next().getValue();
            if (msgMaps.length == 20) break;
            Thread.sleep(100L);
        }
        Assertions.assertEquals((int)20, (int)msgMaps.length);
        consSession.commit();
        result = queueControl.listDeliveringMessages();
        Assertions.assertEquals((int)0, (int)result.size());
        consSession.close();
        prodSession.close();
        connection1.close();
        connection2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFirstMessage() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_BINARY", new Binary("TEST".getBytes()));
            String oneK = new String(new char[1024]).replace("\u0000", "$");
            message.setApplicationProperty("TEST_BIG_BINARY", new Binary(oneK.getBytes(StandardCharsets.UTF_8)));
            message.setApplicationProperty("TEST_STRING", oneK);
            message.setText("NOT_VISIBLE");
            sender.send(message);
            session.commit();
            SimpleString queue = SimpleString.of((String)this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            String firstMessageAsJSON = queueControl.getFirstMessageAsJSON();
            Assertions.assertNotNull((Object)firstMessageAsJSON);
            Assertions.assertTrue((firstMessageAsJSON.length() < 1500 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)firstMessageAsJSON.contains("NOT_VISIBLE"));
            Map[] result = queueControl.listMessages("");
            Assertions.assertEquals((int)1, (int)result.length);
            Map msgMap = result[0];
            Assertions.assertTrue((msgMap.get("TEST_STRING").toString().length() < 512 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFirstMessageWithAMQPTypes() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            UUID uuid = UUID.randomUUID();
            Character character = Character.valueOf('C');
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_UUID", uuid);
            message.setApplicationProperty("TEST_CHAR", character);
            message.setApplicationProperty("TEST_DECIMAL_32", new Decimal32(BigDecimal.ONE));
            message.setApplicationProperty("TEST_DECIMAL_64", new Decimal64(BigDecimal.ONE));
            message.setApplicationProperty("TEST_DECIMAL_128", new Decimal128(BigDecimal.ONE));
            sender.send(message);
            session.commit();
            SimpleString queue = SimpleString.of((String)this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            String firstMessageAsJSON = queueControl.getFirstMessageAsJSON();
            Assertions.assertNotNull((Object)firstMessageAsJSON);
            JsonObject firstMessageObject = JsonUtil.readJsonArray((String)firstMessageAsJSON).getJsonObject(0);
            Assertions.assertEquals((Object)uuid.toString(), (Object)firstMessageObject.getString("TEST_UUID"));
            Assertions.assertEquals((Object)character.toString(), (Object)firstMessageObject.getString("TEST_CHAR"));
            Assertions.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_32"));
            Assertions.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_64"));
            Assertions.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_128"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddressSizeOnDelete() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_STRING", "TEST");
            message.setTimeToLive(100L);
            message.setText("TEST");
            sender.send(message);
            sender.send(message);
            session.commit();
            PagingStore targetPagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName()));
            Assertions.assertNotNull((Object)targetPagingStore);
            Assertions.assertTrue((targetPagingStore.getAddressSize() > 0L ? 1 : 0) != 0);
            SimpleString queue = SimpleString.of((String)this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            Wait.assertEquals((long)2L, () -> ((QueueControl)queueControl).getMessageCount());
            JsonArray array = JsonUtil.readJsonArray((String)queueControl.getFirstMessageAsJSON());
            JsonObject object = (JsonObject)array.get(0);
            queueControl.removeMessage(object.getJsonNumber("messageID").longValue());
            Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
            Map[] messages = queueControl.listMessages("");
            Assertions.assertEquals((int)1, (int)messages.length);
            queueControl.removeMessage(((Long)messages[0].get("messageID")).longValue());
            Assertions.assertEquals((long)0L, (long)queueControl.getMessageCount());
            Wait.assertEquals((long)0L, () -> ((PagingStore)targetPagingStore).getAddressSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountMessagesWithOriginalQueueFilter() throws Exception {
        String queueA = this.getQueueName();
        String queueB = this.getQueueName() + "_B";
        String queueC = this.getQueueName() + "_C";
        QueueControl queueAControl = this.createManagementControl(queueA);
        QueueControl queueBControl = this.createManagementControl(queueB);
        QueueControl queueCControl = this.createManagementControl(queueC);
        int MESSAGE_COUNT = 20;
        this.server.createQueue(QueueConfiguration.of((String)queueB).setAddress(queueB).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueC).setAddress(queueC).setRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender senderA = session.createSender(queueA.toString());
            AmqpSender senderB = session.createSender(queueB.toString());
            for (int i = 0; i < 20; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setText("Message number: " + i);
                senderA.send(message);
                senderB.send(message);
            }
            Assertions.assertEquals((long)20L, (long)queueAControl.countMessages());
            Assertions.assertEquals((long)20L, (long)queueBControl.countMessages());
            Assertions.assertEquals((long)0L, (long)queueCControl.countMessages());
            queueAControl.moveMessages(null, queueC);
            queueBControl.moveMessages(null, queueC);
            Assertions.assertEquals((long)0L, (long)queueAControl.countMessages());
            Assertions.assertEquals((long)0L, (long)queueBControl.countMessages());
            Assertions.assertEquals((long)40L, (long)queueCControl.countMessages());
            String originalGroup = queueCControl.countMessages(null, "_AMQ_ORIG_QUEUE");
            String[] originalSplit = originalGroup.split(",");
            Assertions.assertEquals((int)2, (int)originalSplit.length);
            Assertions.assertTrue((boolean)originalSplit[0].contains("20"));
            Assertions.assertTrue((boolean)originalSplit[1].contains("20"));
            Assertions.assertEquals((Object)("{\"" + queueA + "\":20}"), (Object)queueCControl.countMessages("_AMQ_ORIG_QUEUE = '" + queueA + "'", "_AMQ_ORIG_QUEUE"));
            Assertions.assertEquals((Object)("{\"" + queueB + "\":20}"), (Object)queueCControl.countMessages("_AMQ_ORIG_QUEUE = '" + queueB + "'", "_AMQ_ORIG_QUEUE"));
        }
    }

    protected QueueControl createManagementControl(String queue) throws Exception {
        return this.createManagementControl(SimpleString.of((String)queue), SimpleString.of((String)queue));
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, RoutingType.ANYCAST, this.mBeanServer);
        return queueControl;
    }
}

