/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.jms.RedeployTest;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationConfigurationReloadTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConfigurationWithoutChangesIsIgnoredOnUpdate() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                ProtonProtocolManagerFactory protocolFactory = (ProtonProtocolManagerFactory)this.server.getRemotingService().getProtocolFactoryMap().get("AMQP");
                Assertions.assertNotNull((Object)protocolFactory);
                AMQPFederationAddressPolicyElement updatedReceiveFromAddress = new AMQPFederationAddressPolicyElement();
                updatedReceiveFromAddress.setName("address-policy");
                updatedReceiveFromAddress.addToIncludes("test");
                updatedReceiveFromAddress.setAutoDelete(Boolean.valueOf(true));
                updatedReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
                updatedReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
                AMQPFederatedBrokerConnectionElement updatedElement = new AMQPFederatedBrokerConnectionElement();
                updatedElement.setName(this.getTestName());
                updatedElement.addLocalAddressPolicy(updatedReceiveFromAddress);
                amqpConnection.getConnectionElements().clear();
                amqpConnection.addElement((AMQPBrokerConnectionElement)updatedElement);
                this.server.getConfiguration().getAMQPConnection().clear();
                this.server.getConfiguration().addAMQPConnection(amqpConnection);
                protocolFactory.updateProtocolServices(this.server, Collections.emptyList());
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConnectsToSecondPeerWhenConfigurationUpdatedWithNewConnection() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName() + ":1");
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName() + ":1", "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)(this.getTestName() + ":1")), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                try (ProtonTestServer peer2 = new ProtonTestServer();){
                    peer2.expectSASLAnonymousConnect();
                    peer2.expectOpen().respond();
                    peer2.expectBegin().respond();
                    peer2.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
                    peer2.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
                    peer2.expectFlow().withLinkCredit(10);
                    peer2.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)(this.getTestName() + ":2")), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
                    peer2.expectFlow().withLinkCredit(1000);
                    peer2.start();
                    URI remoteURI2 = peer2.getServerURI();
                    logger.info("Test peer 2 started, peer listening on: {}", (Object)remoteURI2);
                    ProtonProtocolManagerFactory protocolFactory = (ProtonProtocolManagerFactory)this.server.getRemotingService().getProtocolFactoryMap().get("AMQP");
                    Assertions.assertNotNull((Object)protocolFactory);
                    AMQPFederationAddressPolicyElement updatedReceiveFromAddress = new AMQPFederationAddressPolicyElement();
                    updatedReceiveFromAddress.setName("address-policy");
                    updatedReceiveFromAddress.addToIncludes("test");
                    updatedReceiveFromAddress.setAutoDelete(Boolean.valueOf(true));
                    updatedReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
                    updatedReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
                    AMQPFederatedBrokerConnectionElement updatedElement = new AMQPFederatedBrokerConnectionElement();
                    updatedElement.setName(this.getTestName() + ":2");
                    updatedElement.addLocalAddressPolicy(updatedReceiveFromAddress);
                    AMQPBrokerConnectConfiguration updatedAmqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName() + ":2", "tcp://" + remoteURI2.getHost() + ":" + remoteURI2.getPort());
                    updatedAmqpConnection.setReconnectAttempts(0);
                    updatedAmqpConnection.addElement((AMQPBrokerConnectionElement)updatedElement);
                    this.server.getConfiguration().addAMQPConnection(updatedAmqpConnection);
                    protocolFactory.updateProtocolServices(this.server, Collections.emptyList());
                    peer2.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                    peer2.close();
                }
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationDisconnectsFromExistingPeerIfConfigurationRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().optional();
                peer.expectClose().optional();
                peer.expectConnectionToDrop();
                ProtonProtocolManagerFactory protocolFactory = (ProtonProtocolManagerFactory)this.server.getRemotingService().getProtocolFactoryMap().get("AMQP");
                Assertions.assertNotNull((Object)protocolFactory);
                this.server.getConfiguration().clearAMQPConnectionConfigurations();
                protocolFactory.updateProtocolServices(this.server, Collections.emptyList());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                session.createConsumer((Destination)session.createTopic("test"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationUpdatesPolicyAndFederatesQueueInsteadOfAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                session.createConsumer((Destination)session.createQueue("queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().optional();
                peer.expectClose().optional();
                peer.expectConnectionToDrop();
                peer.expectSASLAnonymousConnect();
                peer.expectOpen().respond();
                peer.expectBegin().respond();
                peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
                peer.expectFlow().withLinkCredit(10);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"queue::queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
                peer.expectFlow().withLinkCredit(1000);
                ProtonProtocolManagerFactory protocolFactory = (ProtonProtocolManagerFactory)this.server.getRemotingService().getProtocolFactoryMap().get("AMQP");
                Assertions.assertNotNull((Object)protocolFactory);
                AMQPFederationAddressPolicyElement updatedReceiveFromAddress = new AMQPFederationAddressPolicyElement();
                updatedReceiveFromAddress.setName("address-policy");
                updatedReceiveFromAddress.addToIncludes("test");
                updatedReceiveFromAddress.setAutoDelete(Boolean.valueOf(true));
                updatedReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
                updatedReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
                AMQPFederationQueuePolicyElement updatedReceiveFromQueue = new AMQPFederationQueuePolicyElement();
                updatedReceiveFromQueue.setName("queue-policy");
                updatedReceiveFromQueue.addToIncludes("*", "queue");
                AMQPFederatedBrokerConnectionElement updatedElement = new AMQPFederatedBrokerConnectionElement();
                updatedElement.setName(this.getTestName());
                updatedElement.addLocalQueuePolicy(updatedReceiveFromQueue);
                AMQPBrokerConnectConfiguration updatedAmqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
                updatedAmqpConnection.setReconnectAttempts(0);
                updatedAmqpConnection.addElement((AMQPBrokerConnectionElement)updatedElement);
                this.server.getConfiguration().getAMQPConnection().clear();
                this.server.getConfiguration().addAMQPConnection(updatedAmqpConnection);
                protocolFactory.updateProtocolServices(this.server, Collections.emptyList());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testReloadAmqpConnectionAddressPolicyMatches() throws Exception {
        this.server.start();
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-addresses.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-addresses-reload.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61617");
        ConnectionFactory serverCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();
             Connection serverConnection = serverCF.createConnection();){
            Session session = connection.createSession(1);
            Topic address1 = session.createTopic("address1");
            Topic address2 = session.createTopic("address2");
            MessageConsumer address1Consumer = session.createConsumer((Destination)address1);
            MessageConsumer address2Consumer = session.createConsumer((Destination)address2);
            connection.start();
            Session serverSession = serverConnection.createSession(1);
            MessageProducer address1Producer = serverSession.createProducer((Destination)address1);
            MessageProducer address2Producer = serverSession.createProducer((Destination)address2);
            latch.await(10L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"address1")).isExists());
            TextMessage message = session.createTextMessage("test");
            address1Producer.send((Message)message);
            address2Producer.send((Message)message);
            Assertions.assertNotNull((Object)address1Consumer.receive(5000L));
            Assertions.assertNull((Object)address2Consumer.receiveNoWait());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"address2")).isExists());
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"address2")).getQueueNames().size() > 0);
            address1Producer.send((Message)message);
            address2Producer.send((Message)message);
            Assertions.assertNotNull((Object)address1Consumer.receive(5000L));
            Assertions.assertNotNull((Object)address2Consumer.receive(5000L));
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testReloadAmqpConnectionQueuePolicyMatches() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setRoutingType(RoutingType.ANYCAST).setAddress("queue1").setAutoCreated(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((String)"queue2").setRoutingType(RoutingType.ANYCAST).setAddress("queue2").setAutoCreated(Boolean.valueOf(false)));
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-queues.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-queues-reload.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61617");
        ConnectionFactory serverCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        latch.await(10L, TimeUnit.SECONDS);
        try (Connection connection = factory.createConnection();
             Connection serverConnection = serverCF.createConnection();){
            Session session = connection.createSession(1);
            Queue queue1 = session.createQueue("queue1");
            Queue queue2 = session.createQueue("queue2");
            MessageConsumer queue1Consumer = session.createConsumer((Destination)queue1);
            MessageConsumer queue2Consumer = session.createConsumer((Destination)queue2);
            connection.start();
            Session serverSession = serverConnection.createSession(1);
            MessageProducer queue1Producer = serverSession.createProducer((Destination)queue1);
            MessageProducer queue2Producer = serverSession.createProducer((Destination)queue2);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue1")).isExists());
            TextMessage message = session.createTextMessage("test");
            queue1Producer.send((Message)message);
            queue2Producer.send((Message)message);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue1")).getMessageCount() == 1L);
            Assertions.assertNotNull((Object)queue1Consumer.receiveNoWait());
            Assertions.assertNull((Object)queue2Consumer.receiveNoWait());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue2")).isExists());
            queue1Producer.send((Message)message);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue1")).getMessageCount() == 1L);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue2")).getMessageCount() == 1L);
            Assertions.assertNotNull((Object)queue1Consumer.receiveNoWait());
            Assertions.assertNotNull((Object)queue2Consumer.receiveNoWait());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testReloadAmqpConnectionAddressPolicyReplacedWithQueuePolicy() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setRoutingType(RoutingType.ANYCAST).setAddress("queue1").setAutoCreated(Boolean.valueOf(false)));
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-addresses.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-queues.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61617");
        ConnectionFactory serverCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();
             Connection serverConnection = serverCF.createConnection();){
            Session session = connection.createSession(1);
            Topic address = session.createTopic("address1");
            Queue queue = session.createQueue("queue1");
            MessageConsumer addressConsumer = session.createConsumer((Destination)address);
            MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
            connection.start();
            Session serverSession = serverConnection.createSession(1);
            MessageProducer addressProducer = serverSession.createProducer((Destination)address);
            MessageProducer queueProducer = serverSession.createProducer((Destination)queue);
            latch.await(10L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"address1")).isExists());
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue1")).isExists());
            TextMessage message = session.createTextMessage("test");
            addressProducer.send((Message)message);
            queueProducer.send((Message)message);
            Assertions.assertNotNull((Object)addressConsumer.receive(5000L));
            Assertions.assertNull((Object)queueConsumer.receiveNoWait());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)queueConsumer.receive(5000L));
            Wait.assertTrue(() -> this.server.bindingQuery(SimpleString.of((String)"address2")).getQueueNames().size() == 0);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testReloadAmqpConnectionQueuePolicyMatchesFromBrokerProperties() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setRoutingType(RoutingType.ANYCAST).setAddress("queue1").setAutoCreated(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((String)"queue2").setRoutingType(RoutingType.ANYCAST).setAddress("queue2").setAutoCreated(Boolean.valueOf(false)));
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        Path brokerProperties = this.getTestDirfile().toPath().resolve("broker.properties");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-basic.xml");
        URL propertiesUrl1 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-queues.properties");
        URL propertiesUrl2 = RedeployTest.class.getClassLoader().getResource("reload-amqp-federated-queues-reload.properties");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        Files.copy(propertiesUrl1.openStream(), brokerProperties, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.setPropertiesResourcePath(brokerProperties.toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61617");
        ConnectionFactory serverCF = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        latch.await(10L, TimeUnit.SECONDS);
        try (Connection connection = factory.createConnection();
             Connection serverConnection = serverCF.createConnection();){
            Session session = connection.createSession(1);
            Queue queue1 = session.createQueue("queue1");
            Queue queue2 = session.createQueue("queue2");
            MessageConsumer queue1Consumer = session.createConsumer((Destination)queue1);
            MessageConsumer queue2Consumer = session.createConsumer((Destination)queue2);
            connection.start();
            Session serverSession = serverConnection.createSession(1);
            MessageProducer queue1Producer = serverSession.createProducer((Destination)queue1);
            MessageProducer queue2Producer = serverSession.createProducer((Destination)queue2);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue1")).isExists());
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue2")).isExists());
            TextMessage message = session.createTextMessage("test");
            queue1Producer.send((Message)message);
            queue2Producer.send((Message)message);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue1")).getMessageCount() == 1L);
            Assertions.assertNotNull((Object)queue1Consumer.receiveNoWait());
            Assertions.assertNull((Object)queue2Consumer.receiveNoWait());
            Files.copy(propertiesUrl2.openStream(), brokerProperties, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue1")).isExists());
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"queue2")).isExists());
            queue1Producer.send((Message)message);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue1")).getMessageCount() == 1L);
            Wait.assertTrue(() -> embeddedActiveMQ.getActiveMQServer().queueQuery(SimpleString.of((String)"queue2")).getMessageCount() == 1L);
            Assertions.assertNotNull((Object)queue1Consumer.receiveNoWait());
            Assertions.assertNotNull((Object)queue2Consumer.receiveNoWait());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }
}

